/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class EndlessPearlItem
extends Item {
    private static final int COOLDOWN_TICKS = 160;
    private static final String LAST_USE_TAG = "LastUseTime";

    public EndlessPearlItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            long lastUse = (Long)stack.getOrDefault((DataComponentType)ModComponents.LAST_USE_TIME.get(), (Object)0L);
            long currentTime = level.getGameTime();
            if (currentTime - lastUse >= 160L) {
                ThrownEndlessPearl pearl = new ThrownEndlessPearl(level, player);
                pearl.setItem(stack);
                pearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                level.addFreshEntity((Entity)pearl);
                stack.set((DataComponentType)ModComponents.LAST_USE_TIME.get(), (Object)currentTime);
                player.getCooldowns().addCooldown((Item)this, 160);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.endless_pearl.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.endless_pearl.effect1").withStyle(ChatFormatting.BLUE));
    }

    public static class ThrownEndlessPearl
    extends ThrownEnderpearl {
        public ThrownEndlessPearl(Level level, Player player) {
            super(level, (LivingEntity)player);
        }

        protected void onHit(HitResult result) {
            Entity owner;
            if (!this.level().isClientSide && (owner = this.getOwner()) instanceof Player) {
                Player player = (Player)owner;
                if (player.isPassenger()) {
                    player.stopRiding();
                }
                player.teleportTo(this.getX(), this.getY(), this.getZ());
                player.fallDistance = 0.0f;
                ServerLevel serverLevel = (ServerLevel)this.level();
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, player.getX(), player.getY() + 1.0, player.getZ(), 50, 0.5, 1.0, 0.5, 0.1);
                serverLevel.playSound(null, player.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            this.discard();
        }
    }
}

