/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="bountifulbaubles")
public class EmberItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();
    private static final Map<UUID, Set<BlockPos>> magmaPositions = new HashMap<UUID, Set<BlockPos>>();

    public EmberItem(Item.Properties properties) {
        super(properties.stacksTo(1).fireResistant());
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, Integer.MAX_VALUE, 0, false, false, true));
            }
            player.clearFire();
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (!player.isAlive()) {
            return;
        }
        UUID playerId = player.getUUID();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio(item -> item.getItem() instanceof EmberItem).ifPresent(result -> {
            Level level = player.level();
            Set currentMagmaBlocks = magmaPositions.computeIfAbsent(playerId, k -> new HashSet());
            BlockPos playerPos = player.blockPosition();
            HashSet<BlockPos> neededPositions = new HashSet<BlockPos>();
            neededPositions.add(playerPos.below());
            neededPositions.add(playerPos.below().north());
            neededPositions.add(playerPos.below().south());
            neededPositions.add(playerPos.below().east());
            neededPositions.add(playerPos.below().west());
            Iterator iterator = currentMagmaBlocks.iterator();
            while (iterator.hasNext()) {
                BlockPos pos = (BlockPos)iterator.next();
                if (neededPositions.contains(pos)) continue;
                if (level.getBlockState(pos).is(Blocks.MAGMA_BLOCK)) {
                    level.setBlock(pos, Blocks.LAVA.defaultBlockState(), 3);
                }
                iterator.remove();
            }
            for (BlockPos pos : neededPositions) {
                if (!level.getBlockState(pos).is(Blocks.LAVA) || currentMagmaBlocks.contains(pos)) continue;
                level.setBlock(pos, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
                currentMagmaBlocks.add(pos.immutable());
            }
            if (player.isInLava() || player.getRemainingFireTicks() > 0) {
                player.clearFire();
            }
        }));
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        UUID playerId = player.getUUID();
        Set<BlockPos> blocks = magmaPositions.remove(playerId);
        if (blocks != null) {
            Level level = player.level();
            blocks.forEach(pos -> {
                if (level.getBlockState(pos).is(Blocks.MAGMA_BLOCK)) {
                    level.setBlock(pos, Blocks.LAVA.defaultBlockState(), 3);
                }
            });
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
            player.removeEffect(MobEffects.FIRE_RESISTANCE);
            UUID playerId = player.getUUID();
            Set<BlockPos> blocks = magmaPositions.remove(playerId);
            if (blocks != null) {
                Level level = player.level();
                blocks.forEach(pos -> {
                    if (level.getBlockState(pos).is(Blocks.MAGMA_BLOCK)) {
                        level.setBlock(pos, Blocks.LAVA.defaultBlockState(), 3);
                    }
                });
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.ember.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.ember.effect1").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

