/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class DragonBreathItem
extends ModifiableBaubleItem {
    public DragonBreathItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return ModifiableBaubleItem.Modifier.values();
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    @SubscribeEvent
    public static void onBlockDrop(BlockEvent.BreakEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = event.getPlayer();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        ItemStack tool = player.getMainHandItem();
        if (!event.getState().canHarvestBlock((BlockGetter)serverLevel, pos, player)) {
            return;
        }
        if (EnchantmentHelper.getItemEnchantmentLevel((Holder)event.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)tool) > 0) {
            return;
        }
        boolean hasBreath = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof DragonBreathItem)).isPresent();
        if (!hasBreath) {
            return;
        }
        List drops = Block.getDrops((BlockState)event.getState(), (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        if (drops.isEmpty()) {
            return;
        }
        for (ItemStack drop : drops) {
            Optional<RecipeHolder> recipeHolder = serverLevel.getRecipeManager().getAllRecipesFor(RecipeType.SMELTING).stream().filter(holder -> ((Ingredient)((SmeltingRecipe)holder.value()).getIngredients().get(0)).test(drop)).findFirst();
            if (!recipeHolder.isPresent()) continue;
            ItemStack smeltedItem = ((SmeltingRecipe)recipeHolder.get().value()).getResultItem((HolderLookup.Provider)serverLevel.registryAccess()).copy();
            smeltedItem.setCount(drop.getCount());
            Block.popResource((Level)serverLevel, (BlockPos)pos, (ItemStack)smeltedItem);
            if (!tool.isEmpty() && tool.isDamageableItem()) {
                int damage = 1;
                int unbreakingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)event.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.UNBREAKING), (ItemStack)tool);
                if (unbreakingLevel > 0) {
                    float chance = 1.0f / (float)(unbreakingLevel + 1);
                    if (player.getRandom().nextFloat() < chance) {
                        tool.hurtAndBreak(damage, (LivingEntity)player, null);
                    }
                } else {
                    tool.hurtAndBreak(damage, (LivingEntity)player, null);
                }
            }
            event.setCanceled(true);
            serverLevel.removeBlock(pos, false);
            serverLevel.levelEvent(2001, pos, Block.getId((BlockState)event.getState()));
            return;
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.dragon_breath.effect").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

