/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModComponents;
import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class DarkEggItem
extends ModifiableBaubleItem {
    private static final String TAG_IS_INITIALIZED = "IsInitialized";
    private static final String COOLDOWN_KEY = "DarkEggCooldown";
    public static final String DARK_EGG_CONTROLLED_TAG = "DarkEggControlled";
    public static final String FRIENDLY_VEX_TAG = "FriendlyVex";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public DarkEggItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            long currentTime = player.level().getGameTime();
            Long cooldownEnd = (Long)stack.get(ModComponents.DARK_EGG_COOLDOWN);
            if (cooldownEnd != null && currentTime >= cooldownEnd) {
                stack.remove(ModComponents.DARK_EGG_COOLDOWN);
            }
            if (!player.level().isClientSide()) {
                AABB searchBox = player.getBoundingBox().inflate(32.0);
                player.level().getEntitiesOfClass(Vex.class, searchBox).forEach(vex -> {
                    if (DarkEggItem.isVexFriendly(vex) && (vex.getTarget() == null || vex.getTarget().isDeadOrDying())) {
                        DarkEggItem.followPlayer(vex, player);
                    }
                });
            }
        }
    }

    private static boolean isVexFriendly(Vex vex) {
        return vex.getPersistentData().getBoolean(FRIENDLY_VEX_TAG);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        if (!stack.has(ModComponents.IS_INITIALIZED)) {
            stack.set(ModComponents.IS_INITIALIZED, (Object)true);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    private static void followPlayer(Vex vex, Player player) {
        double followDistance = vex.distanceToSqr((Entity)player);
        AABB searchBox = vex.getBoundingBox().inflate(16.0);
        List nearbyEntities = vex.level().getEntitiesOfClass(LivingEntity.class, searchBox, entity -> entity != player && entity != vex && !(entity instanceof Player) && !entity.getPersistentData().getBoolean(FRIENDLY_VEX_TAG) && entity.isAlive() && (entity.getLastHurtByMob() == player || entity instanceof Vex && !((Vex)entity).getPersistentData().getBoolean(FRIENDLY_VEX_TAG)));
        if (!nearbyEntities.isEmpty()) {
            LivingEntity nearestTarget = (LivingEntity)nearbyEntities.get(0);
            double nearestDistance = vex.distanceToSqr((Entity)nearestTarget);
            for (LivingEntity entity2 : nearbyEntities) {
                double distance = vex.distanceToSqr((Entity)entity2);
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestTarget = entity2;
            }
            vex.setTarget(nearestTarget);
            if (nearestDistance > 64.0) {
                double targetX = nearestTarget.getX() + (vex.getRandom().nextDouble() - 0.5) * 4.0;
                double targetY = nearestTarget.getY() + 1.5;
                double targetZ = nearestTarget.getZ() + (vex.getRandom().nextDouble() - 0.5) * 4.0;
                vex.getMoveControl().setWantedPosition(targetX, targetY, targetZ, 1.2);
            }
            return;
        }
        if (followDistance > 256.0) {
            double angle = vex.getRandom().nextDouble() * Math.PI * 2.0;
            double radius = 8.0 + vex.getRandom().nextDouble() * 4.0;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double offsetY = 2.0 + vex.getRandom().nextDouble() * 2.0;
            vex.moveTo(player.getX() + offsetX, player.getY() + offsetY, player.getZ() + offsetZ);
        } else if (followDistance > 64.0) {
            double angle = Math.atan2(player.getZ() - vex.getZ(), player.getX() - vex.getX());
            double targetRadius = 6.0;
            double targetX = player.getX() + Math.cos(angle) * targetRadius;
            double targetZ = player.getZ() + Math.sin(angle) * targetRadius;
            double targetY = player.getY() + 2.0 + vex.getRandom().nextDouble() * 2.0;
            vex.getMoveControl().setWantedPosition(targetX, targetY, targetZ, 0.8);
        }
    }

    private static void setVexFriendly(Vex vex, Player player) {
        vex.setPersistenceRequired();
        vex.setCustomName((Component)Component.literal((String)(player.getName().getString() + "'s Vex")));
        vex.setCustomNameVisible(true);
        vex.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.5);
        vex.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(48.0);
        vex.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(6.0);
        vex.getPersistentData().putBoolean(DARK_EGG_CONTROLLED_TAG, true);
        vex.getPersistentData().putBoolean(FRIENDLY_VEX_TAG, true);
        vex.getPersistentData().putString("OwnerUUID", player.getStringUUID());
        vex.setLimitedLife(ModConfig.getDarkEggVexLifetime());
        vex.addTag("dark_egg_controlled");
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio(item -> item.getItem() instanceof DarkEggItem).ifPresent(result -> {
                ItemStack stack = result.stack();
                Long cooldown = (Long)stack.get(ModComponents.DARK_EGG_COOLDOWN);
                if (cooldown == null) {
                    Level patt0$temp = player.level();
                    if (patt0$temp instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt0$temp;
                        stack.set(ModComponents.DARK_EGG_COOLDOWN, (Object)(player.level().getGameTime() + (long)ModConfig.getDarkEggCooldown()));
                        serverLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, 1.0f);
                        LivingEntity attacker = null;
                        if (event.getSource().getEntity() instanceof LivingEntity && !(event.getSource().getEntity() instanceof Player)) {
                            attacker = (LivingEntity)event.getSource().getEntity();
                        }
                        LivingEntity finalAttacker = attacker;
                        for (int i = 0; i < ModConfig.getDarkEggVexCount(); ++i) {
                            double angle = Math.PI * 2 * (double)i / (double)ModConfig.getDarkEggVexCount();
                            double radius = 8.0 + player.getRandom().nextDouble() * 4.0;
                            double offsetX = Math.cos(angle) * radius;
                            double offsetZ = Math.sin(angle) * radius;
                            double offsetY = 2.0 + player.getRandom().nextDouble() * 2.0;
                            BlockPos spawnPos = new BlockPos((int)(player.getX() + offsetX), (int)(player.getY() + offsetY), (int)(player.getZ() + offsetZ));
                            Vex vex2 = (Vex)EntityType.VEX.spawn(serverLevel, null, player, spawnPos, MobSpawnType.MOB_SUMMONED, true, false);
                            if (vex2 == null) continue;
                            DarkEggItem.setVexFriendly(vex2, player);
                            if (finalAttacker == null || finalAttacker == player) continue;
                            vex2.setTarget(finalAttacker);
                        }
                    }
                } else {
                    LivingEntity attacker;
                    Entity patt0$temp = event.getSource().getEntity();
                    if (patt0$temp instanceof LivingEntity && (attacker = (LivingEntity)patt0$temp) != player && !(attacker instanceof Player)) {
                        AABB searchBox = player.getBoundingBox().inflate(32.0);
                        player.level().getEntitiesOfClass(Vex.class, searchBox).forEach(vex -> {
                            if (vex.getPersistentData().getBoolean(FRIENDLY_VEX_TAG) && vex.getPersistentData().getString("OwnerUUID").equals(player.getStringUUID())) {
                                vex.setTarget(attacker);
                            }
                        });
                    }
                }
            }));
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LivingEntity target = event.getEntity();
            if (target != null && !(target instanceof Player)) {
                AABB searchBox = player.getBoundingBox().inflate(32.0);
                player.level().getEntitiesOfClass(Vex.class, searchBox).forEach(vex -> {
                    if (vex.getPersistentData().getBoolean(FRIENDLY_VEX_TAG) && vex.getPersistentData().getString("OwnerUUID").equals(player.getStringUUID())) {
                        vex.setTarget(target);
                    }
                });
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.darkegg.effects", (Object[])new Object[]{ModConfig.getDarkEggVexCount(), ModConfig.getDarkEggCooldown() / 20}).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.darkegg.description", (Object[])new Object[]{ModConfig.getDarkEggVexLifetime() / 20}).withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @EventBusSubscriber(modid="bountifulbaubles")
    public class DarkEggEvents {
        public DarkEggEvents(DarkEggItem this$0) {
        }

        @SubscribeEvent
        public static void onVexTarget(LivingChangeTargetEvent event) {
            Player player;
            LivingEntity livingEntity;
            Vex vex;
            LivingEntity livingEntity2 = event.getEntity();
            if (livingEntity2 instanceof Vex && (vex = (Vex)livingEntity2).getPersistentData().getBoolean(DarkEggItem.FRIENDLY_VEX_TAG) && (livingEntity = event.getNewAboutToBeSetTarget()) instanceof Player && CuriosApi.getCuriosInventory((LivingEntity)(player = (Player)livingEntity)).flatMap(curios -> curios.findFirstCurio(stack -> stack.getItem() instanceof DarkEggItem)).isPresent()) {
                event.setCanceled(true);
                vex.setTarget(null);
            }
        }
    }
}

