/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.items.ModSounds;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="bountifulbaubles")
public class DarkDaggerItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public DarkDaggerItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LivingEntity target = event.getEntity();
        if (target == null || target instanceof Player) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio(item -> item.getItem() instanceof DarkDaggerItem).ifPresent(result -> {
            double healthPercentage = target.getHealth() / target.getMaxHealth();
            if (healthPercentage <= ModConfig.getDarkDaggerExecuteThreshold()) {
                event.setNewDamage((float)ModConfig.getDarkDaggerExecuteDamage());
                DarkDaggerItem.playOptimizedEffects(player, target);
            }
        }));
    }

    private static void playOptimizedEffects(Player player, LivingEntity target) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int CIRCLE_PARTICLES = 8;
        int RISE_PARTICLES = 3;
        double radius = 0.8;
        for (int i = 0; i < 8; ++i) {
            double angle = Math.PI * 2 * (double)i / 8.0;
            double x = target.getX() + radius * Math.cos(angle);
            double z = target.getZ() + radius * Math.sin(angle);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL, x, target.getY() + 0.7, z, 1, 0.0, 0.05, 0.0, 0.05);
        }
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL, target.getX(), target.getY() + 0.5, target.getZ(), 3, 0.3, 0.5, 0.3, 0.1);
        level.playSound(null, target.getX(), target.getY(), target.getZ(), (SoundEvent)ModSounds.DARK_DAGGER_EXECUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.dark_dagger.effect", (Object[])new Object[]{(int)(ModConfig.getDarkDaggerExecuteThreshold() * 100.0)}).withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

