/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class CuriousRingItem
extends ModifiableBaubleItem {
    private static final ResourceLocation SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"ring_speed");
    private static final ResourceLocation ARMOR_ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"ring_armor");
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public CuriousRingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        if (CuriousRingItem.isEquipped((LivingEntity)player)) {
            int duration;
            MobEffectInstance current = player.getEffect(MobEffects.DIG_SPEED);
            int n = duration = current != null ? current.getDuration() : 0;
            if (duration <= 30) {
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 60, 0, false, false, true));
            }
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity entity = slotContext.entity();
        if (entity != null) {
            AttributeModifier speedModifier = new AttributeModifier(SPEED_ID, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            entity.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_ID);
            entity.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(speedModifier);
            AttributeModifier armorModifier = new AttributeModifier(ARMOR_ID, 2.0, AttributeModifier.Operation.ADD_VALUE);
            entity.getAttribute(Attributes.ARMOR).removeModifier(ARMOR_ID);
            entity.getAttribute(Attributes.ARMOR).addPermanentModifier(armorModifier);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity entity = slotContext.entity();
        if (entity != null) {
            entity.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_ID);
            entity.getAttribute(Attributes.ARMOR).removeModifier(ARMOR_ID);
            if (entity instanceof Player) {
                entity.removeEffect(MobEffects.DIG_SPEED);
            }
        }
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof CuriousRingItem)).isPresent();
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.curious_ring.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.curious_ring.effect1").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.curious_ring.effect2").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

