/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.SkullOwnerComponent;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class ButchersCleaverItem
extends ModifiableBaubleItem {
    private static final Random RANDOM = new Random();
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public ButchersCleaverItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity victim;
        ItemStack headStack;
        boolean hasButchersCleaver;
        Player killer;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && !(killer = (Player)entity).level().isClientSide() && (hasButchersCleaver = CuriosApi.getCuriosInventory((LivingEntity)killer).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof ButchersCleaverItem)).isPresent()) && (double)RANDOM.nextFloat() < ModConfig.getButchersCleaverDropChance() && !(headStack = ButchersCleaverItem.findEntityHead(victim = event.getEntity())).isEmpty()) {
            victim.spawnAtLocation(headStack);
        }
    }

    private static ItemStack findEntityHead(LivingEntity entity) {
        String[] possiblePatterns;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack head = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            DataComponentMap.Builder builder = DataComponentMap.builder();
            builder.set(SkullOwnerComponent.TYPE, (Object)player.getName().getString());
            head.applyComponents(builder.build());
            return head;
        }
        ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (entityId == null) {
            return ItemStack.EMPTY;
        }
        for (String pattern : possiblePatterns = new String[]{entityId.getNamespace() + ":head_" + entityId.getPath(), entityId.getNamespace() + ":" + entityId.getPath() + "_head", entityId.getNamespace() + ":" + entityId.getPath() + "_skull", entityId.getNamespace() + ":skull_" + entityId.getPath(), entityId.getNamespace() + ":" + entityId.getPath() + "_trophy", entityId.getNamespace() + ":trophy_" + entityId.getPath()}) {
            Item item;
            ResourceLocation itemId = ResourceLocation.tryParse((String)pattern);
            if (itemId == null || (item = (Item)BuiltInRegistries.ITEM.get(itemId)) == null || item.equals(Items.AIR)) continue;
            return new ItemStack((ItemLike)item);
        }
        String entityName = entityId.getPath();
        for (Item item : BuiltInRegistries.ITEM) {
            String itemPath;
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            if (itemId == null || !(itemPath = itemId.getPath().toLowerCase()).contains(entityName) && !entityName.contains(itemPath) || !itemPath.contains("head") && !itemPath.contains("skull") && !itemPath.contains("trophy")) continue;
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.butchers_cleaver.effect").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue() {
        return 0;
    }
}

