/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class BrokenHeartItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public BrokenHeartItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @SubscribeEvent
    public static void onPlayerDamaged(LivingDamageEvent.Pre event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).level().isClientSide()) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio(item -> item.getItem() instanceof BrokenHeartItem).ifPresent(curio -> {
            float maxHealth = player.getMaxHealth();
            float originalDamage = event.getContainer().getOriginalDamage();
            float currentHealth = player.getHealth();
            float absorption = player.getAbsorptionAmount();
            if (!BrokenHeartItem.isLethalDamage((LivingEntity)player, originalDamage)) {
                return;
            }
            if (originalDamage >= maxHealth + currentHealth + absorption) {
                return;
            }
            if (maxHealth <= 1.0f) {
                return;
            }
            float availableOffset = currentHealth + absorption;
            float remainingDamage = originalDamage - availableOffset;
            float healthDeduction = Math.max(remainingDamage, 1.0f);
            BrokenHeartItem.applyHealthDeduction(player, healthDeduction);
            event.getContainer().setNewDamage(0.0f);
            player.setHealth(1.0f);
            player.level().playSound(null, player.blockPosition(), SoundEvents.IRON_GOLEM_HURT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }));
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (player.isSleepingLongEnough()) {
            if (!CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof BrokenHeartItem)).isPresent()) {
                return;
            }
            CompoundTag data = player.getPersistentData();
            AttributeInstance maxHealthAttr = player.getAttribute(Attributes.MAX_HEALTH);
            if (maxHealthAttr == null) {
                return;
            }
            double currentDeduction = data.getDouble("HealthDeduction");
            if (currentDeduction >= 0.0) {
                return;
            }
            ResourceLocation modifierId = ResourceLocation.parse((String)"bountifulbaubles:broken_heart");
            maxHealthAttr.removeModifier(modifierId);
            double baseMaxHealth = maxHealthAttr.getValue();
            double recovery = Math.min(Math.abs(currentDeduction), 4.0);
            double newDeduction = currentDeduction + recovery;
            if (newDeduction < 0.0) {
                maxHealthAttr.addPermanentModifier(new AttributeModifier(modifierId, newDeduction, AttributeModifier.Operation.ADD_VALUE));
            }
            data.putDouble("HealthDeduction", newDeduction);
            float newMaxHealth = (float)maxHealthAttr.getValue();
            float currentHealth = player.getHealth();
            if (currentHealth < newMaxHealth) {
                player.setHealth(Math.min(currentHealth + (float)recovery, newMaxHealth));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.connection.send((Packet)new ClientboundUpdateAttributesPacket(serverPlayer.getId(), Collections.singletonList(maxHealthAttr)));
                MutableComponent message = Component.literal((String)String.format("\u2764 \u7834\u788e\u7684\u5fc3\u751f\u6548\uff01\u751f\u547d\u4e0a\u9650\u6062\u590d \u00a7c%.1f\u00a7c \u70b9", recovery)).withStyle(ChatFormatting.GOLD);
                serverPlayer.sendSystemMessage((Component)message, false);
                serverPlayer.sendSystemMessage((Component)Component.literal((String)String.format("\u5f53\u524d\u6700\u5927\u751f\u547d\u503c: \u00a7c%.1f", Float.valueOf(newMaxHealth))).withStyle(ChatFormatting.GRAY), false);
            }
            player.level().playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, 1.2f);
        }
    }

    private static boolean isLethalDamage(LivingEntity entity, float damage) {
        float maxHealth = entity.getMaxHealth();
        float absorption = entity.getAbsorptionAmount();
        float currentHealth = entity.getHealth();
        return currentHealth + absorption - damage <= 0.0f || damage > maxHealth;
    }

    private static void applyHealthDeduction(Player player, float deduction) {
        float newMaxHealth;
        ResourceLocation modifierId = ResourceLocation.parse((String)"bountifulbaubles:broken_heart");
        AttributeInstance maxHealthAttr = player.getAttribute(Attributes.MAX_HEALTH);
        if (maxHealthAttr == null) {
            return;
        }
        maxHealthAttr.removeModifier(modifierId);
        double baseMaxHealth = maxHealthAttr.getValue();
        double currentDeduction = player.getPersistentData().getDouble("HealthDeduction");
        double newTotalDeduction = currentDeduction - (double)deduction;
        maxHealthAttr.addPermanentModifier(new AttributeModifier(modifierId, newTotalDeduction, AttributeModifier.Operation.ADD_VALUE));
        player.getPersistentData().putDouble("HealthDeduction", newTotalDeduction);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundUpdateAttributesPacket(serverPlayer.getId(), List.of(maxHealthAttr)));
        }
        if ((newMaxHealth = (float)maxHealthAttr.getValue()) <= 0.0f) {
            player.setHealth(0.0f);
            player.kill();
        } else {
            player.setHealth(1.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        CompoundTag data = player.getPersistentData();
        if (data.contains("HealthDeduction")) {
            double deduction = data.getDouble("HealthDeduction");
            ResourceLocation modifierId = ResourceLocation.parse((String)"bountifulbaubles:broken_heart");
            AttributeInstance maxHealthAttr = player.getAttribute(Attributes.MAX_HEALTH);
            if (maxHealthAttr != null) {
                maxHealthAttr.removeModifier(modifierId);
                maxHealthAttr.addPermanentModifier(new AttributeModifier(modifierId, deduction, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.broken_heart.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.broken_heart.effect1").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.broken_heart.lore").withStyle(ChatFormatting.GREEN));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

