/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import com.jinqinxixi.bountifulbaubles.network.DoubleJumpPacket;
import com.jinqinxixi.bountifulbaubles.network.DoubleJumpParticlePacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;

@EventBusSubscriber(modid="bountifulbaubles")
public class BottledCloudItem
extends ModifiableBaubleItem {
    private static final String JUMP_KEY = "bountifulbaubles:double_jumps";
    private static final int MAX_JUMPS = 1;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public BottledCloudItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.onGround()) {
            player.getPersistentData().putInt(JUMP_KEY, 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        boolean canDoubleJump;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        boolean isFalling = player.getDeltaMovement().y <= 0.0;
        boolean bl = canDoubleJump = BottledCloudItem.isEquipped((LivingEntity)player) && !player.onGround() && isFalling && player.getPersistentData().getInt(JUMP_KEY) > 0;
        if (mc.options.keyJump.isDown() && canDoubleJump) {
            player.getPersistentData().putInt(JUMP_KEY, 0);
            if (mc.getConnection() != null) {
                mc.getConnection().send((CustomPacketPayload)new DoubleJumpPacket());
            }
            player.playSound(SoundEvents.WOOL_FALL, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
        }
    }

    public static void performDoubleJump(Player player) {
        if (!BottledCloudItem.isEquipped((LivingEntity)player)) {
            return;
        }
        player.fallDistance = 0.0f;
        double verticalSpeed = 0.5;
        if (player.hasEffect(MobEffects.JUMP)) {
            int amplifier = player.getEffect(MobEffects.JUMP).getAmplifier();
            verticalSpeed += 0.1 * (double)(amplifier + 1);
        }
        if (player.isSprinting()) {
            Vec3 currentMotion = player.getDeltaMovement();
            float yaw = player.getYRot() * ((float)Math.PI / 180);
            double horizontalBoost = player.isSprinting() ? ModConfig.getSprintJumpHorizontal() : 0.0;
            Vec3 addedMotion = new Vec3((double)(-Mth.sin((float)yaw)) * horizontalBoost, (verticalSpeed *= 1.0 + ModConfig.getSprintJumpVertical()) - currentMotion.y, (double)Mth.cos((float)yaw) * horizontalBoost);
            player.setDeltaMovement(player.getDeltaMovement().add(addedMotion));
        }
        Vec3 currentMotion = player.getDeltaMovement();
        player.setDeltaMovement(currentMotion.x, verticalSpeed, currentMotion.z);
        player.hasImpulse = true;
        player.hurtMarked = true;
        player.awardStat(Stats.JUMP);
        if (player.isSprinting()) {
            player.causeFoodExhaustion(0.2f);
        } else {
            player.causeFoodExhaustion(0.05f);
        }
        if (!player.level().isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (CustomPacketPayload)new DoubleJumpParticlePacket(player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && BottledCloudItem.isEquipped((LivingEntity)(player = (Player)livingEntity))) {
            event.setDistance(Math.max(0.0f, event.getDistance() - 3.0f));
        }
    }

    public static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof BottledCloudItem)).isPresent();
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.bottled_cloud.double_jump").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

