/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@EventBusSubscriber(modid="bountifulbaubles")
public class AutoTorchItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public AutoTorchItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide || !player.isAlive() || player.tickCount % 20 != 0) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> {
            for (Map.Entry entry : curios.getCurios().entrySet()) {
                ICurioStacksHandler handler = (ICurioStacksHandler)entry.getValue();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStacks().getStackInSlot(i);
                    if (!(stack.getItem() instanceof AutoTorchItem)) continue;
                    AutoTorchItem.processTorchPlacement(player, level);
                }
            }
        });
    }

    private static void processTorchPlacement(Player player, Level level) {
        BlockPos torchPos = player.blockPosition();
        if (AutoTorchItem.shouldPlaceTorch(level, torchPos)) {
            level.setBlockAndUpdate(torchPos, Blocks.TORCH.defaultBlockState());
            level.playSound(null, torchPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static boolean shouldPlaceTorch(Level level, BlockPos pos) {
        return level.getMaxLocalRawBrightness(pos) <= 6 && level.getFluidState(pos).isEmpty() && (level.isEmptyBlock(pos) || level.getBlockState(pos).canBeReplaced()) && Blocks.TORCH.defaultBlockState().canSurvive((LevelReader)level, pos);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.auto_torch.function").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

