/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import com.jinqinxixi.bountifulbaubles.util.BaubleUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="bountifulbaubles")
public class AnkhCharmItem
extends ModifiableBaubleItem {
    private static final Holder<MobEffect>[] ANKH_CHARM_EFFECTS = new Holder[]{MobEffects.DARKNESS, MobEffects.WITHER, MobEffects.CONFUSION, MobEffects.MOVEMENT_SLOWDOWN, MobEffects.HUNGER, MobEffects.LEVITATION, MobEffects.BLINDNESS, MobEffects.DIG_SLOWDOWN, MobEffects.WEAKNESS, MobEffects.POISON};
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public AnkhCharmItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity entity = slotContext.entity();
        for (Holder<MobEffect> effectHolder : ANKH_CHARM_EFFECTS) {
            entity.removeEffect(effectHolder);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    @SubscribeEvent
    public static void onEffectApplicable(MobEffectEvent.Applicable event) {
        Holder effectHolder = event.getEffectInstance().getEffect();
        if (AnkhCharmItem.shouldBlockEffect(event.getEntity(), (Holder<MobEffect>)effectHolder)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    private static boolean shouldBlockEffect(LivingEntity entity, Holder<MobEffect> effectHolder) {
        for (Holder<MobEffect> target : ANKH_CHARM_EFFECTS) {
            if (effectHolder != target) continue;
            return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof AnkhCharmItem)).isPresent();
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player == null || player.level().isClientSide()) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> {
            if (curios.findFirstCurio(stack -> stack.getItem() instanceof AnkhCharmItem).isPresent()) {
                BaubleUtils.destroyNearbyWebs(player);
            }
        });
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.ankh_charm.effect").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

