/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.client;

import com.jinqinxixi.bountifulbaubles.items.Baubles.MindsEyeItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="bountifulbaubles", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class MarkerRenderer {
    private static final ResourceLocation MARKER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"textures/misc/target_marker.png");
    private static final float MARKER_SIZE = 0.5f;

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        PoseStack poseStack = event.getPoseStack();
        for (Map.Entry<UUID, Map.Entry<Integer, Long>> entry : MindsEyeItem.getMarkedTargets().entrySet()) {
            Entity target = mc.level.getEntity(entry.getValue().getKey().intValue());
            if (target == null) continue;
            double interpEntityX = target.xo + (target.getX() - target.xo) * (double)partialTicks;
            double interpEntityY = target.yo + (target.getY() - target.yo) * (double)partialTicks;
            double interpEntityZ = target.zo + (target.getZ() - target.zo) * (double)partialTicks;
            double entityHeight = target.getBbHeight();
            Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
            poseStack.pushPose();
            poseStack.translate(interpEntityX - cameraPos.x, interpEntityY + entityHeight + 0.7 - cameraPos.y, interpEntityZ - cameraPos.z);
            poseStack.mulPose(mc.gameRenderer.getMainCamera().rotation());
            MarkerRenderer.renderMarker(poseStack);
            poseStack.popPose();
        }
    }

    private static void renderMarker(PoseStack poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARKER_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float halfSize = 0.25f;
        Matrix4f pose = poseStack.last().pose();
        buffer.addVertex(pose, -halfSize, -halfSize, 0.0f).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255);
        buffer.addVertex(pose, -halfSize, halfSize, 0.0f).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255);
        buffer.addVertex(pose, halfSize, halfSize, 0.0f).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255);
        buffer.addVertex(pose, halfSize, -halfSize, 0.0f).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }
}

