/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles;

import com.jinqinxixi.bountifulbaubles.BountifulBaublesMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ModConfig {
    public static final String CATEGORY_BAUBLES = "baubles";
    public static final String CATEGORY_JUMP = "jump_settings";
    public static final String CATEGORY_ANVIL = "anvil_settings";
    public static final String CATEGORY_LOOT = "loot_settings";
    public static ModConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    private static final String BAUBLES_REFORKED_MOD_ID = "baublesreforked";
    private static boolean baublesReforkedLoaded;
    private static final Map<ResourceLocation, ModConfigSpec.ConfigValue<String>> LOOT_MAPPING;
    public static Map<ResourceLocation, List<LootEntry>> lootConfig;

    public static int getAnvilRecastExpCost() {
        return (Integer)ModConfig.COMMON.ANVIL_RECAST_EXP_COST.get();
    }

    public static int getAnvilRecastMaterialCost() {
        return (Integer)ModConfig.COMMON.ANVIL_RECAST_MATERIAL_COST.get();
    }

    public static boolean isEnableCrossNecklaceEffect() {
        return (Boolean)ModConfig.COMMON.enableCrossNecklaceEffect.get();
    }

    public static boolean isPlayersOnly() {
        return (Boolean)ModConfig.COMMON.playersOnly.get();
    }

    public static double getInvulnBoost() {
        return (Double)ModConfig.COMMON.invulnBoost.get();
    }

    public static double getVampiricPercent() {
        return (Double)ModConfig.COMMON.vampiricPercent.get();
    }

    public static double getVampiricMax() {
        return (Double)ModConfig.COMMON.vampiricMax.get();
    }

    public static double getSprintJumpVertical() {
        return (Double)ModConfig.COMMON.sprintJumpVertical.get();
    }

    public static double getSprintJumpHorizontal() {
        return (Double)ModConfig.COMMON.sprintJumpHorizontal.get();
    }

    public static boolean isModifierEnabled() {
        return (Boolean)ModConfig.COMMON.enableModifierSystem.get();
    }

    public static int getTotemCooldown() {
        return (Integer)ModConfig.COMMON.totemCooldown.get();
    }

    public static double getAttackSpeedBoost() {
        return (Double)ModConfig.COMMON.attackSpeedBoost.get();
    }

    public static double getHuskAppleChance() {
        return (Double)ModConfig.COMMON.huskAppleChance.get();
    }

    public static double getStrayRingChance() {
        return (Double)ModConfig.COMMON.strayRingChance.get();
    }

    public static double getShulkerHeartChance() {
        return (Double)ModConfig.COMMON.shulkerHeartChance.get();
    }

    public static double getCaveSpiderBezoarChance() {
        return (Double)ModConfig.COMMON.caveSpiderBezoarChance.get();
    }

    public static double getEvokerTotemChance() {
        return (Double)ModConfig.COMMON.evokerTotemChance.get();
    }

    public static double getElderGuardianVitaminsChance() {
        return (Double)ModConfig.COMMON.elderGuardianVitaminsChance.get();
    }

    public static double getEnderDragonScaleChance() {
        return (Double)ModConfig.COMMON.enderDragonScaleChance.get();
    }

    public static int getEnderDragonScaleMinCount() {
        return (Integer)ModConfig.COMMON.enderDragonScaleMinCount.get();
    }

    public static int getEnderDragonScaleMaxCount() {
        return (Integer)ModConfig.COMMON.enderDragonScaleMaxCount.get();
    }

    public static int getTacticalScanInterval() {
        return (Integer)ModConfig.COMMON.TACTICAL_SCAN_INTERVAL.get();
    }

    public static int getTacticalMarkDuration() {
        return (Integer)ModConfig.COMMON.TACTICAL_MARK_DURATION.get();
    }

    public static double getTacticalScanRadius() {
        return (Double)ModConfig.COMMON.TACTICAL_SCAN_RADIUS.get();
    }

    public static double getTacticalUpRange() {
        return (Double)ModConfig.COMMON.TACTICAL_UP_RANGE.get();
    }

    public static double getTacticalDownRange() {
        return (Double)ModConfig.COMMON.TACTICAL_DOWN_RANGE.get();
    }

    public static double getTacticalDamageMultiplier() {
        return (Double)ModConfig.COMMON.TACTICAL_DAMAGE_MULTIPLIER.get();
    }

    public static List<Double> getLuckCoinDamageBonuses() {
        return new ArrayList<Double>((Collection)ModConfig.COMMON.LUCK_COIN_DAMAGE_BONUSES.get());
    }

    public static List<Double> getLuckCoinProbabilities() {
        return new ArrayList<Double>((Collection)ModConfig.COMMON.LUCK_COIN_PROBABILITIES.get());
    }

    public static double getThaWizardDurationMultiplier() {
        return (Double)ModConfig.COMMON.THA_WIZARD_DURATION_MULTIPLIER.get();
    }

    public static double getDropSpindleRepairChance() {
        return (Double)ModConfig.COMMON.DROP_SPINDLE_REPAIR_CHANCE.get();
    }

    public static int getDropSpindleRepairAmount() {
        return (Integer)ModConfig.COMMON.DROP_SPINDLE_REPAIR_AMOUNT.get();
    }

    public static int getDarkEggCooldown() {
        return (Integer)ModConfig.COMMON.DARK_EGG_COOLDOWN.get();
    }

    public static int getDarkEggVexCount() {
        return (Integer)ModConfig.COMMON.DARK_EGG_VEX_COUNT.get();
    }

    public static int getDarkEggVexLifetime() {
        return (Integer)ModConfig.COMMON.DARK_EGG_VEX_LIFETIME.get();
    }

    public static int getMossyRingRepairInterval() {
        return (Integer)ModConfig.COMMON.MOSSY_RING_REPAIR_INTERVAL.get();
    }

    public static int getMossyRingRepairAmount() {
        return (Integer)ModConfig.COMMON.MOSSY_RING_REPAIR_AMOUNT.get();
    }

    public static int getMossyBeltRepairInterval() {
        return (Integer)ModConfig.COMMON.MOSSY_BELT_REPAIR_INTERVAL.get();
    }

    public static int getMossyBeltRepairAmount() {
        return (Integer)ModConfig.COMMON.MOSSY_BELT_REPAIR_AMOUNT.get();
    }

    public static int getMadAuraCooldown() {
        return (Integer)ModConfig.COMMON.MAD_AURA_COOLDOWN.get();
    }

    public static double getDarkDaggerExecuteThreshold() {
        return (Double)ModConfig.COMMON.DARK_DAGGER_EXECUTE_THRESHOLD.get();
    }

    public static double getDarkDaggerExecuteDamage() {
        return (Double)ModConfig.COMMON.DARK_DAGGER_EXECUTE_DAMAGE.get();
    }

    public static int getBlazeHeartDuration() {
        return (Integer)ModConfig.COMMON.BLAZE_HEART_DURATION.get();
    }

    public static int getWrathPendantEffectLevel() {
        return (Integer)ModConfig.COMMON.WRATH_PENDANT_EFFECT_LEVEL.get();
    }

    public static int getWrathPendantEffectDuration() {
        return (Integer)ModConfig.COMMON.WRATH_PENDANT_EFFECT_DURATION.get();
    }

    public static double getGoldenSkullDropChance() {
        return (Double)ModConfig.COMMON.GOLDEN_SKULL_DROP_CHANCE.get();
    }

    public static double getButchersCleaverDropChance() {
        return (Double)ModConfig.COMMON.BUTCHERS_CLEAVER_DROP_CHANCE.get();
    }

    public static double getRubyHeartHealthThreshold() {
        return (Double)ModConfig.COMMON.RUBY_HEART_HEALTH_THRESHOLD.get();
    }

    public static int getRubyHeartCooldown() {
        return (Integer)ModConfig.COMMON.RUBY_HEART_COOLDOWN.get();
    }

    public static double getRockCandySpeedMultiplier() {
        return (Double)ModConfig.COMMON.ROCK_CANDY_SPEED_MULTIPLIER.get();
    }

    public static double getRockCandyDamageMultiplier() {
        return (Double)ModConfig.COMMON.ROCK_CANDY_DAMAGE_MULTIPLIER.get();
    }

    public static String getTreasureBagItems() {
        return (String)ModConfig.COMMON.TREASURE_BAG_ITEMS.get();
    }

    private ModConfigSpec.ConfigValue<String> defineLoot(ModConfigSpec.Builder builder, String configKey, String structureId, String comment, String defaultValue) {
        return builder.comment(comment + "\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u591a\u4e2a\u6761\u76ee\u7528\u5206\u53f7\u5206\u9694\uff09\n\u7ed3\u6784ID\uff1a" + structureId).define(configKey + "Loot", (Object)defaultValue);
    }

    public static void loadLootConfig() {
        lootConfig.clear();
        LOOT_MAPPING.forEach((tableId, config) -> {
            String value = (String)config.get();
            if (value.isEmpty()) {
                return;
            }
            List<LootEntry> entries = ModConfig.parseLootEntries(value);
            if (!entries.isEmpty()) {
                lootConfig.put((ResourceLocation)tableId, entries);
            }
        });
    }

    private static List<LootEntry> parseLootEntries(String configValue) {
        ArrayList<LootEntry> entries = new ArrayList<LootEntry>();
        for (String entry : configValue.split(";")) {
            String[] parts = entry.split(",");
            if (parts.length != 4) {
                BountifulBaublesMod.LOGGER.warn("Invalid loot entry format: {}", (Object)entry);
                continue;
            }
            try {
                ResourceLocation itemId = ResourceLocation.parse((String)parts[0].trim());
                entries.add(new LootEntry(itemId, Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()), Integer.parseInt(parts[3].trim())));
            }
            catch (ResourceLocationException e) {
                BountifulBaublesMod.LOGGER.error("Invalid resource location in loot entry: {}", (Object)entry, (Object)e);
            }
            catch (NumberFormatException e) {
                BountifulBaublesMod.LOGGER.error("Invalid number format in loot entry: {}", (Object)entry, (Object)e);
            }
        }
        return entries;
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        COMMON = new CommonConfig(builder);
        COMMON_SPEC = builder.build();
        LOOT_MAPPING = new HashMap<ResourceLocation, ModConfigSpec.ConfigValue<String>>();
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/desert_pyramid"), ModConfig.COMMON.DESERT_PYRAMID_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/jungle_temple"), ModConfig.COMMON.JUNGLE_TEMPLE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/abandoned_mineshaft"), ModConfig.COMMON.ABANDONED_MINESHAFT_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/stronghold_library"), ModConfig.COMMON.STRONGHOLD_LIBRARY_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/woodland_mansion"), ModConfig.COMMON.WOODLAND_MANSION_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_temple"), ModConfig.COMMON.VILLAGE_TEMPLE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/shipwreck_treasure"), ModConfig.COMMON.SHIPWRECK_TREASURE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/pillager_outpost"), ModConfig.COMMON.PILLAGER_OUTPOST_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/buried_treasure"), ModConfig.COMMON.BURIED_TREASURE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/underwater_ruin_big"), ModConfig.COMMON.UNDERWATER_RUIN_BIG_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/underwater_ruin_small"), ModConfig.COMMON.UNDERWATER_RUIN_SMALL_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/igloo_chest"), ModConfig.COMMON.IGLOO_CHEST_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/bastion_treasure"), ModConfig.COMMON.BASTION_TREASURE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/bastion_bridge"), ModConfig.COMMON.BASTION_BRIDGE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/bastion_housing"), ModConfig.COMMON.BASTION_HOUSING_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/bastion_other"), ModConfig.COMMON.BASTION_OTHER_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/ruined_portal"), ModConfig.COMMON.RUINED_PORTAL_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/end_city_treasure"), ModConfig.COMMON.END_CITY_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/ancient_city"), ModConfig.COMMON.ANCIENT_CITY_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/simple_dungeon"), ModConfig.COMMON.SIMPLE_DUNGEON_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/stronghold_corridor"), ModConfig.COMMON.STRONGHOLD_CORRIDOR_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/fossil_dinosaur"), ModConfig.COMMON.FOSSIL_DINOSAUR_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/fossil_mammal"), ModConfig.COMMON.FOSSIL_MAMMAL_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/shipwreck_supply"), ModConfig.COMMON.SHIPWRECK_SUPPLY_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/woodland_mansion_cartography"), ModConfig.COMMON.WOODLAND_CARTOGRAPHY_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/stronghold_crossing"), ModConfig.COMMON.STRONGHOLD_CROSSING_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/shipwreck_map"), ModConfig.COMMON.SHIPWRECK_MAP_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_armorer"), ModConfig.COMMON.VILLAGE_ARMORER_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_butcher"), ModConfig.COMMON.VILLAGE_BUTCHER_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_cartographer"), ModConfig.COMMON.VILLAGE_CARTOGRAPHER_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_plains_house"), ModConfig.COMMON.VILLAGE_PLAINS_HOUSE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_fisher"), ModConfig.COMMON.VILLAGE_FISHER_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_fletcher"), ModConfig.COMMON.VILLAGE_FLETCHER_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_tannery"), ModConfig.COMMON.VILLAGE_TANNERY_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_library"), ModConfig.COMMON.VILLAGE_LIBRARY_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_mason"), ModConfig.COMMON.VILLAGE_MASON_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_shepherd"), ModConfig.COMMON.VILLAGE_SHEPHERD_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_toolsmith"), ModConfig.COMMON.VILLAGE_TOOLSMITH_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_weaponsmith"), ModConfig.COMMON.VILLAGE_WEAPONSMITH_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_desert_house"), ModConfig.COMMON.VILLAGE_DESERT_HOUSE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_snowy_house"), ModConfig.COMMON.VILLAGE_SNOWY_HOUSE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_savanna_house"), ModConfig.COMMON.VILLAGE_SAVANNA_HOUSE_LOOT);
        LOOT_MAPPING.put(ResourceLocation.parse((String)"minecraft:chests/village/village_taiga_house"), ModConfig.COMMON.VILLAGE_TAIGA_HOUSE_LOOT);
        lootConfig = new HashMap<ResourceLocation, List<LootEntry>>();
    }

    public static class CommonConfig {
        public final ModConfigSpec.BooleanValue enableCrossNecklaceEffect;
        public final ModConfigSpec.BooleanValue playersOnly;
        public final ModConfigSpec.DoubleValue invulnBoost;
        public final ModConfigSpec.DoubleValue vampiricPercent;
        public final ModConfigSpec.DoubleValue vampiricMax;
        public final ModConfigSpec.BooleanValue enableModifierSystem;
        public final ModConfigSpec.IntValue ANVIL_RECAST_EXP_COST;
        public final ModConfigSpec.IntValue ANVIL_RECAST_MATERIAL_COST;
        public final ModConfigSpec.IntValue TACTICAL_SCAN_INTERVAL;
        public final ModConfigSpec.IntValue TACTICAL_MARK_DURATION;
        public final ModConfigSpec.DoubleValue TACTICAL_SCAN_RADIUS;
        public final ModConfigSpec.DoubleValue TACTICAL_UP_RANGE;
        public final ModConfigSpec.DoubleValue TACTICAL_DOWN_RANGE;
        public final ModConfigSpec.DoubleValue TACTICAL_DAMAGE_MULTIPLIER;
        public final ModConfigSpec.ConfigValue<List<? extends Double>> LUCK_COIN_DAMAGE_BONUSES;
        public final ModConfigSpec.ConfigValue<List<? extends Double>> LUCK_COIN_PROBABILITIES;
        public final ModConfigSpec.DoubleValue THA_WIZARD_DURATION_MULTIPLIER;
        public final ModConfigSpec.DoubleValue DROP_SPINDLE_REPAIR_CHANCE;
        public final ModConfigSpec.IntValue DROP_SPINDLE_REPAIR_AMOUNT;
        public final ModConfigSpec.IntValue DARK_EGG_COOLDOWN;
        public final ModConfigSpec.IntValue DARK_EGG_VEX_COUNT;
        public final ModConfigSpec.IntValue DARK_EGG_VEX_LIFETIME;
        public final ModConfigSpec.IntValue MOSSY_RING_REPAIR_INTERVAL;
        public final ModConfigSpec.IntValue MOSSY_RING_REPAIR_AMOUNT;
        public final ModConfigSpec.IntValue MOSSY_BELT_REPAIR_INTERVAL;
        public final ModConfigSpec.IntValue MOSSY_BELT_REPAIR_AMOUNT;
        public final ModConfigSpec.IntValue MAD_AURA_COOLDOWN;
        public final ModConfigSpec.DoubleValue DARK_DAGGER_EXECUTE_THRESHOLD;
        public final ModConfigSpec.DoubleValue DARK_DAGGER_EXECUTE_DAMAGE;
        public final ModConfigSpec.IntValue BLAZE_HEART_DURATION;
        public final ModConfigSpec.IntValue WRATH_PENDANT_EFFECT_LEVEL;
        public final ModConfigSpec.IntValue WRATH_PENDANT_EFFECT_DURATION;
        public final ModConfigSpec.DoubleValue GOLDEN_SKULL_DROP_CHANCE;
        public final ModConfigSpec.DoubleValue BUTCHERS_CLEAVER_DROP_CHANCE;
        public final ModConfigSpec.DoubleValue RUBY_HEART_HEALTH_THRESHOLD;
        public final ModConfigSpec.IntValue RUBY_HEART_COOLDOWN;
        public final ModConfigSpec.DoubleValue ROCK_CANDY_SPEED_MULTIPLIER;
        public final ModConfigSpec.DoubleValue ROCK_CANDY_DAMAGE_MULTIPLIER;
        public final ModConfigSpec.ConfigValue<String> TREASURE_BAG_ITEMS;
        public final ModConfigSpec.DoubleValue sprintJumpVertical;
        public final ModConfigSpec.DoubleValue sprintJumpHorizontal;
        public final ModConfigSpec.IntValue totemCooldown;
        public final ModConfigSpec.DoubleValue attackSpeedBoost;
        public final ModConfigSpec.DoubleValue huskAppleChance;
        public final ModConfigSpec.DoubleValue strayRingChance;
        public final ModConfigSpec.DoubleValue shulkerHeartChance;
        public final ModConfigSpec.DoubleValue caveSpiderBezoarChance;
        public final ModConfigSpec.DoubleValue evokerTotemChance;
        public final ModConfigSpec.DoubleValue elderGuardianVitaminsChance;
        public final ModConfigSpec.DoubleValue enderDragonScaleChance;
        public final ModConfigSpec.IntValue enderDragonScaleMinCount;
        public final ModConfigSpec.IntValue enderDragonScaleMaxCount;
        public final ModConfigSpec.ConfigValue<String> DESERT_PYRAMID_LOOT;
        public final ModConfigSpec.ConfigValue<String> JUNGLE_TEMPLE_LOOT;
        public final ModConfigSpec.ConfigValue<String> ABANDONED_MINESHAFT_LOOT;
        public final ModConfigSpec.ConfigValue<String> STRONGHOLD_LIBRARY_LOOT;
        public final ModConfigSpec.ConfigValue<String> WOODLAND_MANSION_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_TEMPLE_LOOT;
        public final ModConfigSpec.ConfigValue<String> SHIPWRECK_TREASURE_LOOT;
        public final ModConfigSpec.ConfigValue<String> PILLAGER_OUTPOST_LOOT;
        public final ModConfigSpec.ConfigValue<String> BURIED_TREASURE_LOOT;
        public final ModConfigSpec.ConfigValue<String> UNDERWATER_RUIN_BIG_LOOT;
        public final ModConfigSpec.ConfigValue<String> UNDERWATER_RUIN_SMALL_LOOT;
        public final ModConfigSpec.ConfigValue<String> IGLOO_CHEST_LOOT;
        public final ModConfigSpec.ConfigValue<String> BASTION_TREASURE_LOOT;
        public final ModConfigSpec.ConfigValue<String> BASTION_BRIDGE_LOOT;
        public final ModConfigSpec.ConfigValue<String> BASTION_HOUSING_LOOT;
        public final ModConfigSpec.ConfigValue<String> BASTION_OTHER_LOOT;
        public final ModConfigSpec.ConfigValue<String> RUINED_PORTAL_LOOT;
        public final ModConfigSpec.ConfigValue<String> END_CITY_LOOT;
        public final ModConfigSpec.ConfigValue<String> ANCIENT_CITY_LOOT;
        public final ModConfigSpec.ConfigValue<String> SIMPLE_DUNGEON_LOOT;
        public final ModConfigSpec.ConfigValue<String> STRONGHOLD_CORRIDOR_LOOT;
        public final ModConfigSpec.ConfigValue<String> FOSSIL_DINOSAUR_LOOT;
        public final ModConfigSpec.ConfigValue<String> FOSSIL_MAMMAL_LOOT;
        public final ModConfigSpec.ConfigValue<String> SHIPWRECK_SUPPLY_LOOT;
        public final ModConfigSpec.ConfigValue<String> WOODLAND_CARTOGRAPHY_LOOT;
        public final ModConfigSpec.ConfigValue<String> STRONGHOLD_CROSSING_LOOT;
        public final ModConfigSpec.ConfigValue<String> SHIPWRECK_MAP_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_ARMORER_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_BUTCHER_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_CARTOGRAPHER_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_PLAINS_HOUSE_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_FISHER_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_FLETCHER_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_TANNERY_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_LIBRARY_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_MASON_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_SHEPHERD_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_TOOLSMITH_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_WEAPONSMITH_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_DESERT_HOUSE_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_SNOWY_HOUSE_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_SAVANNA_HOUSE_LOOT;
        public final ModConfigSpec.ConfigValue<String> VILLAGE_TAIGA_HOUSE_LOOT;

        public CommonConfig(ModConfigSpec.Builder builder) {
            baublesReforkedLoaded = ModList.get().isLoaded(ModConfig.BAUBLES_REFORKED_MOD_ID);
            builder.comment("\u9970\u54c1\u901a\u7528\u8bbe\u7f6e").push(ModConfig.CATEGORY_BAUBLES);
            this.enableModifierSystem = builder.comment(new String[]{"\u662f\u5426\u542f\u7528\u9970\u54c1\u4fee\u9970\u5668\u7cfb\u7edf", "\u6ce8\u610f\uff1a\u5982\u679c\u68c0\u6d4b\u5230\u5b89\u88c5\u4e86 Baubles Reforked \u6a21\u7ec4\uff0c\u6b64\u9009\u9879\u9ed8\u8ba4\u4e3a false", "\u4f60\u4ecd\u7136\u53ef\u4ee5\u624b\u52a8\u542f\u7528\u6b64\u9009\u9879\uff0c\u4f46\u4e0d\u5efa\u8bae\u540c\u65f6\u4f7f\u7528\u4e24\u4e2a\u6a21\u7ec4\u7684\u4fee\u9970\u7b26\u7cfb\u7edf", "Whether to enable the accessory modifier system", "Note: If Baubles Reforked mod is detected, this option defaults to false", "You can still enable this option manually, but it's not recommended to use both mods' modifier systems simultaneously"}).define("modifierEnabled", !baublesReforkedLoaded);
            builder.comment(new String[]{"\u94c1\u7827\u91cd\u94f8\u8bbe\u7f6e", "Anvil Reforging Settings"}).push(ModConfig.CATEGORY_ANVIL);
            this.ANVIL_RECAST_EXP_COST = builder.comment(new String[]{"\u91cd\u94f8\u6d88\u8017\u7ecf\u9a8c\u503c [\u9ed8\u8ba43\u7ea7]", "Experience cost for reforging [default 3 levels]"}).defineInRange("recast_exp_cost", 3, 0, 100);
            this.ANVIL_RECAST_MATERIAL_COST = builder.comment(new String[]{"\u91cd\u94f8\u6d88\u8017\u6750\u6599\u6570\u91cf [\u9ed8\u8ba41\u4e2a]", "Material cost for reforging [default 1 item]"}).defineInRange("recast_material_cost", 1, 1, 64);
            builder.pop();
            builder.comment(new String[]{"\u5341\u5b57\u9879\u94fe\u8bbe\u7f6e", "Cross Necklace Settings"}).push("cross_necklace");
            this.enableCrossNecklaceEffect = builder.comment(new String[]{"\u542f\u7528\u65e0\u654c\u6548\u679c [true/false]", "Enable invulnerability effect [true/false]"}).define("enable", true);
            this.playersOnly = builder.comment(new String[]{"\u662f\u5426\u4ec5\u73a9\u5bb6\u751f\u6548 [true/false]", "Apply effect to players only [true/false]"}).define("playersOnly", true);
            this.invulnBoost = builder.comment(new String[]{"\u65e0\u654c\u65f6\u95f4\u52a0\u6210\u500d\u6570 [0.0-10.0]", "Invulnerability time multiplier [0.0-10.0]"}).defineInRange("boost", 0.8, 0.0, 10.0);
            builder.pop();
            builder.comment(new String[]{"\u5438\u8840\u624b\u5957\u8bbe\u7f6e", "Vampiric Glove Settings"}).push("vampiric_glove");
            this.vampiricPercent = builder.comment(new String[]{"\u4f24\u5bb3\u8f6c\u5316\u6bd4\u4f8b [0.0-1.0]", "Damage to healing conversion ratio [0.0-1.0]"}).defineInRange("percent", 0.4, 0.0, 1.0);
            this.vampiricMax = builder.comment(new String[]{"\u5355\u6b21\u6700\u5927\u6062\u590d\u91cf [0.0-20.0]", "Maximum healing per hit [0.0-20.0]"}).defineInRange("maxHeal", 6.0, 0.0, 20.0);
            builder.pop();
            builder.comment(new String[]{"\u7075\u654f\u624b\u5957\u8bbe\u7f6e", "Dexterity Glove Settings"}).push("dexterity_glove");
            this.attackSpeedBoost = builder.comment(new String[]{"\u653b\u51fb\u901f\u5ea6\u52a0\u6210\u503c [\u9ed8\u8ba40.4\uff0c1.0=+100%]", "Attack speed bonus [default 0.4, 1.0=+100%]"}).defineInRange("attack_speed", 0.4, 0.0, 2.0);
            builder.pop();
            builder.comment(new String[]{"\u65e0\u9650\u56fe\u817e\u8bbe\u7f6e", "Infinite Totem Settings"}).push("infinite_totem");
            this.totemCooldown = builder.comment(new String[]{"\u65e0\u9650\u56fe\u817e\u51b7\u5374\u65f6\u95f4\uff08\u5355\u4f4d\uff1a\u6e38\u620f\u523b\uff0c20\u523b=1\u79d2\uff09[\u9ed8\u8ba4200\u523b=10\u79d2]", "Infinite Totem cooldown (in ticks, 20 ticks = 1 second) [default 200 ticks = 10 seconds]"}).defineInRange("cooldown", 6000, 20, 72000);
            builder.pop();
            builder.comment(new String[]{"\u4e8c\u6bb5\u8df3\u8bbe\u7f6e", "Double Jump Settings"}).push(ModConfig.CATEGORY_JUMP);
            this.sprintJumpVertical = builder.comment(new String[]{"\u75be\u8dd1\u5782\u76f4\u52a0\u6210\u7cfb\u6570 [\u9ed8\u8ba40.5] \u793a\u4f8b\uff1a0.5 = +50%", "Sprint jump vertical boost [default 0.5] Example: 0.5 = +50%"}).defineInRange("sprint_vertical", 0.5, 0.0, 2.0);
            this.sprintJumpHorizontal = builder.comment(new String[]{"\u75be\u8dd1\u6c34\u5e73\u63a8\u8fdb\u529b [\u9ed8\u8ba40.5] \u5355\u4f4d\uff1a\u65b9\u5757/tick", "Sprint jump horizontal boost [default 0.5] Unit: blocks/tick"}).defineInRange("sprint_horizontal", 0.5, 0.0, 5.0);
            builder.pop();
            builder.push("Tactical Goggles Settings").comment(new String[]{"\u6d1e\u5bdf\u4e4b\u773c\u76f8\u5173\u914d\u7f6e", "Tactical Goggles Configuration"});
            this.TACTICAL_SCAN_INTERVAL = builder.comment(new String[]{"\u626b\u63cf\u95f4\u9694\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Scan interval (in ticks, 20 ticks = 1 second)"}).defineInRange("scanInterval", 300, 1, 1200);
            this.TACTICAL_MARK_DURATION = builder.comment(new String[]{"\u6807\u8bb0\u6301\u7eed\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff09", "Mark duration (in ticks)"}).defineInRange("markDuration", 100, 1, 600);
            this.TACTICAL_SCAN_RADIUS = builder.comment(new String[]{"\u6c34\u5e73\u626b\u63cf\u534a\u5f84", "Horizontal scan radius"}).defineInRange("scanRadius", 10.0, 1.0, 32.0);
            this.TACTICAL_UP_RANGE = builder.comment(new String[]{"\u5411\u4e0a\u626b\u63cf\u8303\u56f4", "Upward scan range"}).defineInRange("upRange", 5.0, 1.0, 16.0);
            this.TACTICAL_DOWN_RANGE = builder.comment(new String[]{"\u5411\u4e0b\u626b\u63cf\u8303\u56f4", "Downward scan range"}).defineInRange("downRange", 5.0, 1.0, 16.0);
            this.TACTICAL_DAMAGE_MULTIPLIER = builder.comment(new String[]{"\u5bf9\u6807\u8bb0\u76ee\u6807\u7684\u4f24\u5bb3\u500d\u7387", "Damage multiplier against marked targets"}).defineInRange("damageMultiplier", 1.5, 1.0, 5.0);
            builder.pop();
            builder.push("Lucky Coin Settings").comment(new String[]{"\u5e78\u8fd0\u786c\u5e01\u76f8\u5173\u914d\u7f6e", "Lucky Coin Configuration"});
            this.LUCK_COIN_DAMAGE_BONUSES = builder.comment(new String[]{"\u4f24\u5bb3\u52a0\u6210\u5217\u8868\uff080.05\u8868\u793a+5%\u4f24\u5bb3\uff09", "Damage bonus list (0.05 means +5% damage)"}).defineList("damageBonus", Arrays.asList(0.05, 0.1, 0.3), o -> o instanceof Double && (Double)o >= 0.0 && (Double)o <= 5.0);
            this.LUCK_COIN_PROBABILITIES = builder.comment(new String[]{"\u6bcf\u4e2a\u4f24\u5bb3\u52a0\u6210\u5bf9\u5e94\u7684\u89e6\u53d1\u6982\u7387\uff08\u5fc5\u987b\u548c\u4f24\u5bb3\u52a0\u6210\u6570\u7ec4\u957f\u5ea6\u76f8\u540c\uff0c\u4e14\u6982\u7387\u548c\u5fc5\u987b\u7b49\u4e8e1.0\uff09", "Trigger probability for each damage bonus (must match the length of damage bonus array and sum up to 1.0)"}).defineList("probability", Arrays.asList(0.7, 0.2, 0.1), o -> o instanceof Double && (Double)o >= 0.0 && (Double)o <= 1.0);
            builder.pop();
            builder.push("Tha Wizard Settings").comment(new String[]{"\u5c0f\u5deb\u5e08\u9970\u54c1\u76f8\u5173\u914d\u7f6e", "Tha Wizard Accessory Configuration"});
            this.THA_WIZARD_DURATION_MULTIPLIER = builder.comment(new String[]{"\u836f\u6c34\u6548\u679c\u6301\u7eed\u65f6\u95f4\u500d\u7387 (1.5 = \u5ef6\u957f50%)", "Potion effect duration multiplier (1.5 = +50% duration)"}).defineInRange("durationMultiplier", 1.5, 1.0, 5.0);
            builder.pop();
            builder.push("Drop Spindle Settings").comment(new String[]{"\u7eba\u9524\u76f8\u5173\u914d\u7f6e", "Drop Spindle Configuration"});
            this.DROP_SPINDLE_REPAIR_CHANCE = builder.comment(new String[]{"\u6bcf\u6b21\u653b\u51fb\u65f6\u89e6\u53d1\u4fee\u590d\u7684\u6982\u7387 (0.25 = 25%)", "Chance to trigger repair on attack (0.25 = 25%)"}).defineInRange("repairChance", 0.25, 0.0, 1.0);
            this.DROP_SPINDLE_REPAIR_AMOUNT = builder.comment(new String[]{"\u6bcf\u6b21\u4fee\u590d\u7684\u8010\u4e45\u5ea6", "Amount of durability repaired per trigger"}).defineInRange("repairAmount", 1, 1, 64);
            builder.pop();
            builder.push("Dark Egg Settings").comment(new String[]{"\u6697\u5f71\u4e4b\u5375\u76f8\u5173\u914d\u7f6e", "Dark Egg Configuration"});
            this.DARK_EGG_COOLDOWN = builder.comment(new String[]{"\u6280\u80fd\u51b7\u5374\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Ability cooldown (in ticks, 20 ticks = 1 second)"}).defineInRange("cooldown", 1200, 200, 6000);
            this.DARK_EGG_VEX_COUNT = builder.comment(new String[]{"\u6bcf\u6b21\u53ec\u5524\u7684\u607c\u9b3c\u6570\u91cf", "Number of Vexes summoned per use"}).defineInRange("vexCount", 3, 1, 10);
            this.DARK_EGG_VEX_LIFETIME = builder.comment(new String[]{"\u607c\u9b3c\u5b58\u6d3b\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff09", "Vex lifetime duration (in ticks)"}).defineInRange("vexLifetime", 600, 100, 2400);
            builder.pop();
            builder.push("Mossy Ring Settings").comment(new String[]{"\u82d4\u85d3\u6212\u6307\u76f8\u5173\u914d\u7f6e", "Mossy Ring Configuration"});
            this.MOSSY_RING_REPAIR_INTERVAL = builder.comment(new String[]{"\u4fee\u590d\u95f4\u9694\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Repair interval (in ticks, 20 ticks = 1 second)"}).defineInRange("repairInterval", 60, 20, 200);
            this.MOSSY_RING_REPAIR_AMOUNT = builder.comment(new String[]{"\u6bcf\u6b21\u4fee\u590d\u7684\u8010\u4e45\u5ea6", "Amount of durability repaired per tick"}).defineInRange("repairAmount", 1, 1, 10);
            builder.pop();
            builder.push("Mossy Belt Settings").comment(new String[]{"\u82d4\u85d3\u8170\u5e26\u76f8\u5173\u914d\u7f6e", "Mossy Belt Configuration"});
            this.MOSSY_BELT_REPAIR_INTERVAL = builder.comment(new String[]{"\u4fee\u590d\u95f4\u9694\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Repair interval (in ticks, 20 ticks = 1 second)"}).defineInRange("repairInterval", 60, 20, 200);
            this.MOSSY_BELT_REPAIR_AMOUNT = builder.comment(new String[]{"\u6bcf\u6b21\u4fee\u590d\u7684\u8010\u4e45\u5ea6", "Amount of durability repaired per tick"}).defineInRange("repairAmount", 1, 1, 10);
            builder.pop();
            builder.push("Mad Aura Settings").comment(new String[]{"\u70bd\u5149\u73af\u76f8\u5173\u914d\u7f6e", "Mad Aura Configuration"});
            this.MAD_AURA_COOLDOWN = builder.comment(new String[]{"\u6280\u80fd\u51b7\u5374\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Ability cooldown (in ticks, 20 ticks = 1 second)"}).defineInRange("cooldown", 600, 200, 2400);
            builder.pop();
            builder.push("Dark Dagger Settings").comment(new String[]{"\u6697\u5f71\u5315\u9996\u76f8\u5173\u914d\u7f6e", "Dark Dagger Configuration"});
            this.DARK_DAGGER_EXECUTE_THRESHOLD = builder.comment(new String[]{"\u65a9\u6740\u9608\u503c\uff08\u76ee\u6807\u5269\u4f59\u751f\u547d\u503c\u767e\u5206\u6bd4\uff0c0.2 = 20%\uff09", "Execute threshold (target's remaining health percentage, 0.2 = 20%)"}).defineInRange("executeThreshold", 0.2, 0.05, 0.5);
            this.DARK_DAGGER_EXECUTE_DAMAGE = builder.comment(new String[]{"\u65a9\u6740\u4f24\u5bb3\u503c", "Execute damage amount"}).defineInRange("executeDamage", 9.99999999E8, 1000.0, 9.99999999E8);
            builder.pop();
            builder.push("Blaze Heart Settings").comment(new String[]{"\u70c8\u7130\u4e4b\u5fc3\u76f8\u5173\u914d\u7f6e", "Blaze Heart Configuration"});
            this.BLAZE_HEART_DURATION = builder.comment(new String[]{"\u751f\u547d\u6062\u590d\u6548\u679c\u6301\u7eed\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Regeneration effect duration (in ticks, 20 ticks = 1 second)"}).defineInRange("regenerationDuration", 900, 20, 2400);
            builder.pop();
            builder.push("Wrath Pendant Settings").comment(new String[]{"\u6124\u6012\u540a\u5760\u76f8\u5173\u914d\u7f6e", "Wrath Pendant Configuration"});
            this.WRATH_PENDANT_EFFECT_LEVEL = builder.comment(new String[]{"\u66b4\u51fb\u65f6\u7ed9\u4e88\u7684\u7f6a\u6076\u6548\u679c\u7b49\u7ea7 [\u9ed8\u8ba43]", "Level of Sin effect given on critical hit [default 3]"}).defineInRange("effectLevel", 3, 0, 10);
            this.WRATH_PENDANT_EFFECT_DURATION = builder.comment(new String[]{"\u7f6a\u6076\u6548\u679c\u6301\u7eed\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09[\u9ed8\u8ba4100tick = 5\u79d2]", "Sin effect duration (in ticks, 20 ticks = 1 second) [default 100 ticks = 5 seconds]"}).defineInRange("effectDuration", 100, 20, 1200);
            builder.pop();
            builder.push("Golden Skull Settings").comment("\u9ec4\u91d1\u5934\u9885\u76f8\u5173\u914d\u7f6e");
            this.GOLDEN_SKULL_DROP_CHANCE = builder.comment(new String[]{"\u9ec4\u91d1\u5934\u9885\u9970\u54c1\u89e6\u53d1\u5b9d\u85cf\u888b\u6389\u843d\u7684\u6982\u7387 (0.0-1.0)", "Chance for Golden Skull accessory to trigger treasure bag drops (0.0-1.0)"}).defineInRange("goldenSkullDropChance", 0.05, 0.0, 1.0);
            builder.pop();
            builder.push("Butcher's Cleaver Settings").comment("\u5c60\u5bb0\u9570\u76f8\u5173\u914d\u7f6e");
            this.BUTCHERS_CLEAVER_DROP_CHANCE = builder.comment(new String[]{"\u5c60\u5bb0\u9570\u9970\u54c1\u89e6\u53d1\u5934\u9885\u6389\u843d\u7684\u6982\u7387 (0.0-1.0)", "Chance for Butcher's Cleaver accessory to trigger head drops (0.0-1.0)"}).defineInRange("butchersCleaverDropChance", 0.1, 0.0, 1.0);
            builder.pop();
            builder.push("Ruby Heart Settings").comment("\u7ea2\u5b9d\u77f3\u4e4b\u5fc3\u76f8\u5173\u914d\u7f6e");
            this.RUBY_HEART_COOLDOWN = builder.comment(new String[]{"\u7ea2\u5b9d\u77f3\u4e4b\u5fc3\u89e6\u53d1\u540e\u7684\u51b7\u5374\u65f6\u95f4\uff08\u4ee5\u79d2\u4e3a\u5355\u4f4d\uff09", "Ruby Heart cooldown after activation (in seconds)"}).defineInRange("rubyHeartCooldown", 60, 1, 3600);
            this.RUBY_HEART_HEALTH_THRESHOLD = builder.comment(new String[]{"\u7ea2\u5b9d\u77f3\u4e4b\u5fc3\u89e6\u53d1\u6240\u9700\u7684\u751f\u547d\u503c\u9608\u503c\uff08\u5360\u6700\u5927\u751f\u547d\u503c\u7684\u767e\u5206\u6bd4\uff0c0.0-1.0\uff09", "Ruby Heart activation health threshold (percentage of max health, 0.0-1.0)"}).defineInRange("rubyHeartHealthThreshold", 0.3, 0.0, 1.0);
            builder.pop();
            builder.push("Rock Candy Settings").comment("\u6c34\u6676\u7cd6\u9970\u54c1\u76f8\u5173\u914d\u7f6e");
            this.ROCK_CANDY_SPEED_MULTIPLIER = builder.comment(new String[]{"\u6c34\u6676\u7cd6\u9970\u54c1\u7684\u79fb\u52a8\u901f\u5ea6\u500d\u7387\uff081.0 = \u57fa\u7840\u901f\u5ea6\u7ffb\u500d\uff09", "Rock Candy accessory movement speed multiplier (1.0 = double base speed)"}).defineInRange("rockCandySpeedMultiplier", 1.0, 0.0, 5.0);
            this.ROCK_CANDY_DAMAGE_MULTIPLIER = builder.comment(new String[]{"\u6c34\u6676\u7cd6\u9970\u54c1\u53d7\u5230\u7684\u4f24\u5bb3\u500d\u7387\uff082.0 = \u4f24\u5bb3\u7ffb\u500d\uff09", "Rock Candy accessory damage taken multiplier (2.0 = double damage)"}).defineInRange("rockCandyDamageMultiplier", 2.0, 1.0, 5.0);
            builder.pop();
            builder.comment("Treasure Bag Settings").push("treasure_bag");
            this.TREASURE_BAG_ITEMS = builder.comment(new String[]{"\u5b9d\u85cf\u888b\u53ef\u80fd\u6389\u843d\u7684\u7269\u54c1\u5217\u8868", "List of possible items from treasure bags", "", "\u683c\u5f0f\uff1amodid:\u7269\u54c1ID,\u6743\u91cd", "Format: modid:item_id,weight", "", "\u793a\u4f8b\uff1aminecraft:diamond,10", "Example: minecraft:diamond,10", "", "\u5982\u679c\u6743\u91cd\u76f8\u540c\uff0c\u7269\u54c1\u6389\u843d\u6982\u7387\u76f8\u7b49", "Items will have equal chances if weights are the same"}).define("possible_items", (Object)"bountifulbaubles:minds_eye,10;bountifulbaubles:luck_coin,10;bountifulbaubles:dragon_breath,10;bountifulbaubles:ice_shard,10;bountifulbaubles:tha_spider,10;bountifulbaubles:creepo,10;bountifulbaubles:tha_wizard,10;bountifulbaubles:book_o_enchanting,10;bountifulbaubles:warm_void,10;bountifulbaubles:golden_melon,10;bountifulbaubles:fire_mind,10;bountifulbaubles:drop_spindle,10;bountifulbaubles:dark_egg,10;bountifulbaubles:mossy_ring,10;bountifulbaubles:mossy_belt,10;bountifulbaubles:mad_aura,10;bountifulbaubles:turtle_shell,10;bountifulbaubles:dark_dagger,10;bountifulbaubles:ember,10;bountifulbaubles:wither_nail,10;bountifulbaubles:serpent_tooth,10;bountifulbaubles:blaze_heart,10;bountifulbaubles:starfish,10;bountifulbaubles:golden_skull,10;bountifulbaubles:butchers_cleaver,10;bountifulbaubles:karma,10;bountifulbaubles:oxalis,10;bountifulbaubles:glory_shards,10;bountifulbaubles:ruby_heart,10;bountifulbaubles:rock_candy,10");
            builder.pop();
            builder.comment(new String[]{"\u6218\u5229\u54c1\u6389\u843d\u8bbe\u7f6e", "Loot Drop Settings"}).push(ModConfig.CATEGORY_LOOT);
            this.huskAppleChance = builder.comment(new String[]{"\u5c38\u58f3\u6389\u843d\u91d1\u82f9\u679c\u7684\u6982\u7387 [0.0-1.0]", "Chance for Husks to drop Golden Apple [0.0-1.0]"}).defineInRange("huskAppleChance", 0.05, 0.0, 1.0);
            this.strayRingChance = builder.comment(new String[]{"\u6d41\u6d6a\u8005\u6389\u843d\u8d85\u9891\u6212\u6307\u7684\u6982\u7387 [0.0-1.0]", "Chance for Strays to drop Overclocker Ring [0.0-1.0]"}).defineInRange("strayRingChance", 0.1, 0.0, 1.0);
            this.shulkerHeartChance = builder.comment(new String[]{"\u6f5c\u5f71\u8d1d\u6389\u843d\u7d2b\u5f71\u5fc3\u810f\u7684\u6982\u7387 [0.0-1.0]", "Chance for Shulkers to drop Shulker Heart [0.0-1.0]"}).defineInRange("shulkerHeartChance", 0.25, 0.0, 1.0);
            this.caveSpiderBezoarChance = builder.comment(new String[]{"\u6d1e\u7a74\u8718\u86db\u6389\u843d\u89e3\u6bd2\u73e0\u7684\u6982\u7387 [0.0-1.0]", "Chance for Cave Spiders to drop Bezoar [0.0-1.0]"}).defineInRange("caveSpiderBezoarChance", 0.15, 0.0, 1.0);
            this.evokerTotemChance = builder.comment(new String[]{"\u5524\u9b54\u8005\u6389\u843d\u65e0\u9650\u56fe\u817e\u7684\u6982\u7387 [0.0-1.0]", "Chance for Evokers to drop Infinite Totem [0.0-1.0]"}).defineInRange("evokerTotemChance", 0.05, 0.0, 1.0);
            this.elderGuardianVitaminsChance = builder.comment(new String[]{"\u8fdc\u53e4\u5b88\u536b\u8005\u6389\u843d\u7ef4\u751f\u7d20\u6982\u7387 [0.0-1.0]", "Chance for Elder Guardians to drop Vitamins [0.0-1.0]"}).defineInRange("elder_guardian_vitamins_chance", 1.0, 0.0, 1.0);
            this.enderDragonScaleChance = builder.comment(new String[]{"\u672b\u5f71\u9f99\u9cde\u7247\u6389\u843d\u6982\u7387 [0.0-1.0]", "Chance for Ender Dragon to drop Dragon Scales [0.0-1.0]"}).defineInRange("dragon_scale_chance", 1.0, 0.0, 1.0);
            this.enderDragonScaleMinCount = builder.comment(new String[]{"\u672b\u5f71\u9f99\u9cde\u7247\u6700\u5c0f\u6389\u843d\u6570\u91cf", "Minimum number of Dragon Scales dropped"}).defineInRange("dragon_scale_min_count", 3, 1, 64);
            this.enderDragonScaleMaxCount = builder.comment(new String[]{"\u672b\u5f71\u9f99\u9cde\u7247\u6700\u5927\u6389\u843d\u6570\u91cf", "Maximum number of Dragon Scales dropped"}).defineInRange("dragon_scale_max_count", 6, 1, 64);
            builder.pop();
            builder.comment(new String[]{"\u7ed3\u6784\u6218\u5229\u54c1\u914d\u7f6e\n\u914d\u7f6e\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf;\u591a\u4e2a\u7269\u54c1\u7528\u5206\u53f7\u5206\u9694", "Format: itemID,weight,minCount,maxCount;multiple items separated by semicolons"}).push("Loot Settings");
            this.DESERT_PYRAMID_LOOT = builder.comment("\u6c99\u6f20\u795e\u6bbf\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("desertPyramidLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,3;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:broken_heart,1,1,2;bountifulbaubles:lucky_horseshoe,1,1,2;bountifulbaubles:bottled_cloud,1,1,2;bountifulbaubles:endless_pearl,1,1,2;bountifulbaubles:treasure_bag,2,1,2");
            this.JUNGLE_TEMPLE_LOOT = builder.comment("\u4e1b\u6797\u795e\u5e99\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("jungleTempleLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:curious_amulet,3,1,2;bountifulbaubles:curious_ring,3,1,2;bountifulbaubles:vampiric_glove,1,1,2;bountifulbaubles:gauntlets_dexterity,2,1,2;bountifulbaubles:treasure_bag,2,1,2");
            this.ABANDONED_MINESHAFT_LOOT = builder.comment("\u5e9f\u5f03\u77ff\u4e95\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("abandonedMineshaftLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:sunglasses,3,1,2;bountifulbaubles:curious_crown,3,1,2;bountifulbaubles:auto_torch,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
            this.STRONGHOLD_LIBRARY_LOOT = builder.comment("\u8981\u585e\u56fe\u4e66\u9986\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("strongholdLibraryLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.WOODLAND_MANSION_LOOT = builder.comment("\u6797\u5730\u5e9c\u90b8\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("woodlandMansionLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.VILLAGE_TEMPLE_LOOT = builder.comment("\u6751\u5e84\u6559\u5802\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageTempleLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.SHIPWRECK_TREASURE_LOOT = builder.comment("\u6c89\u8239\u5b9d\u85cf\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("shipwreckTreasureLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.PILLAGER_OUTPOST_LOOT = builder.comment("\u63a0\u593a\u8005\u524d\u54e8\u7ad9\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("pillagerOutpostLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:black_dragon_scale,3,1,2;bountifulbaubles:phylactery_charm,1,1,2;bountifulbaubles:treasure_bag,2,1,2");
            this.BURIED_TREASURE_LOOT = builder.comment("\u57cb\u85cf\u5b9d\u85cf\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("buriedTreasureLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,6,1,2;bountifulbaubles:wormhole_mirror,1,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.UNDERWATER_RUIN_BIG_LOOT = builder.comment("\u5927\u578b\u6c34\u4e0b\u5e9f\u589f\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("underwaterRuinBigLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.UNDERWATER_RUIN_SMALL_LOOT = builder.comment("\u5c0f\u578b\u6c34\u4e0b\u5e9f\u589f\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("underwaterRuinSmallLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.IGLOO_CHEST_LOOT = builder.comment("\u96ea\u5c4b\u5730\u4e0b\u5ba4\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("iglooChestLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.BASTION_TREASURE_LOOT = builder.comment("\u5821\u5792\u9057\u8ff9-\u5b9d\u85cf\u5ba4\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("bastionTreasureLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:amulet_sin_empty,8,1,7;bountifulbaubles:curious_knuckles,2,1,1;bountifulbaubles:treasure_bag,2,1,2");
            this.BASTION_BRIDGE_LOOT = builder.comment("\u5821\u5792\u9057\u8ff9-\u6865\u6881\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("bastionBridgeLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:amulet_sin_empty,5,1,3;bountifulbaubles:curious_knuckles,2,1,1;bountifulbaubles:treasure_bag,2,1,2");
            this.BASTION_HOUSING_LOOT = builder.comment("\u5821\u5792\u9057\u8ff9-\u5c45\u4f4f\u533a\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("bastionHousingLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:amulet_sin_empty,5,1,3;bountifulbaubles:curious_knuckles,2,1,1;bountifulbaubles:treasure_bag,2,1,2");
            this.BASTION_OTHER_LOOT = builder.comment("\u5821\u5792\u9057\u8ff9-\u6742\u9879\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("bastionOtherLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:amulet_sin_empty,5,1,3;bountifulbaubles:curious_knuckles,2,1,1;bountifulbaubles:treasure_bag,2,1,2");
            this.RUINED_PORTAL_LOOT = builder.comment("\u5e9f\u5f03\u4f20\u9001\u95e8\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("ruinedPortalLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:obsidian_skull,3,1,2;bountifulbaubles:auto_torch,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
            this.END_CITY_LOOT = builder.comment("\u672b\u5730\u57ce\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("endCityLoot", (Object)"bountifulbaubles:wrath_pendant,5,1,3;bountifulbaubles:gluttony_pendant,3,1,2;bountifulbaubles:pride_pendant,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
            this.ANCIENT_CITY_LOOT = builder.comment("\u8fdc\u53e4\u57ce\u5e02\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("ancientCityLoot", (Object)"bountifulbaubles:wrath_pendant,5,1,3;bountifulbaubles:gluttony_pendant,3,1,2;bountifulbaubles:pride_pendant,3,1,2;bountifulbaubles:cross_necklace,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
            this.SIMPLE_DUNGEON_LOOT = builder.comment("\u5c0f\u578b\u5730\u7262\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("simpleDungeonLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:balloon,3,1,1;bountifulbaubles:cobalt_shield,3,1,1;bountifulbaubles:auto_torch,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
            this.STRONGHOLD_CORRIDOR_LOOT = builder.comment("\u8981\u585e\u8d70\u5eca\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("strongholdCorridorLoot", (Object)"bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.FOSSIL_DINOSAUR_LOOT = builder.comment("\u6050\u9f99\u5316\u77f3\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("fossilDinosaurLoot", (Object)"");
            this.FOSSIL_MAMMAL_LOOT = builder.comment("\u54fa\u4e73\u52a8\u7269\u5316\u77f3\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("fossilMammalLoot", (Object)"");
            this.SHIPWRECK_SUPPLY_LOOT = builder.comment("\u6c89\u8239\u8865\u7ed9\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("shipwreckSupplyLoot", (Object)"bountifulbaubles:potion_wormhole,3,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.WOODLAND_CARTOGRAPHY_LOOT = builder.comment("\u6797\u5730\u5236\u56fe\u5ba4\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("woodlandCartographyLoot", (Object)"bountifulbaubles:potion_wormhole,3,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.STRONGHOLD_CROSSING_LOOT = builder.comment("\u8981\u585e\u5341\u5b57\u5385\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("strongholdCrossingLoot", (Object)"bountifulbaubles:potion_wormhole,3,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.SHIPWRECK_MAP_LOOT = builder.comment("\u6c89\u8239\u5730\u56fe\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("shipwreckMapLoot", (Object)"bountifulbaubles:potion_wormhole,3,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
            this.VILLAGE_ARMORER_LOOT = builder.comment("\u76d4\u7532\u5320\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageArmorerLoot", (Object)"");
            this.VILLAGE_BUTCHER_LOOT = builder.comment("\u5c60\u592b\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageButcherLoot", (Object)"");
            this.VILLAGE_CARTOGRAPHER_LOOT = builder.comment("\u5236\u56fe\u5e08\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageCartographerLoot", (Object)"");
            this.VILLAGE_PLAINS_HOUSE_LOOT = builder.comment("\u5e73\u539f\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villagePlainsHouseLoot", (Object)"");
            this.VILLAGE_FISHER_LOOT = builder.comment("\u6e14\u592b\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageFisherLoot", (Object)"");
            this.VILLAGE_FLETCHER_LOOT = builder.comment("\u5236\u7bad\u5e08\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageFletcherLoot", (Object)"");
            this.VILLAGE_TANNERY_LOOT = builder.comment("\u5236\u9769\u5382\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageTanneryLoot", (Object)"");
            this.VILLAGE_LIBRARY_LOOT = builder.comment("\u6751\u5e84\u56fe\u4e66\u9986\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageLibraryLoot", (Object)"");
            this.VILLAGE_MASON_LOOT = builder.comment("\u77f3\u5320\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageMasonLoot", (Object)"");
            this.VILLAGE_SHEPHERD_LOOT = builder.comment("\u7267\u7f8a\u4eba\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageShepherdLoot", (Object)"");
            this.VILLAGE_TOOLSMITH_LOOT = builder.comment("\u5de5\u5177\u5320\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageToolsmithLoot", (Object)"");
            this.VILLAGE_WEAPONSMITH_LOOT = builder.comment("\u6b66\u5668\u5320\u6218\u5229\u54c1\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageWeaponsmithLoot", (Object)"");
            this.VILLAGE_DESERT_HOUSE_LOOT = builder.comment("\u6c99\u6f20\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageDesertHouseLoot", (Object)"");
            this.VILLAGE_SNOWY_HOUSE_LOOT = builder.comment("\u96ea\u539f\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageSnowyHouseLoot", (Object)"");
            this.VILLAGE_SAVANNA_HOUSE_LOOT = builder.comment("\u70ed\u5e26\u8349\u539f\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageSavannaHouseLoot", (Object)"");
            this.VILLAGE_TAIGA_HOUSE_LOOT = builder.comment("\u9488\u53f6\u6797\u6751\u5e84\u623f\u5c4b\u914d\u7f6e\n\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf\uff08\u7528\u5206\u53f7\u5206\u9694\uff09").define("villageTaigaHouseLoot", (Object)"");
        }
    }

    public static class LootEntry {
        public final ResourceLocation itemId;
        public final int weight;
        public final int minRolls;
        public final int maxRolls;

        public LootEntry(ResourceLocation itemId, int weight, int minRolls, int maxRolls) {
            this.itemId = itemId;
            this.weight = weight;
            this.minRolls = minRolls;
            this.maxRolls = maxRolls;
        }
    }
}

