/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles;

import com.jinqinxixi.bountifulbaubles.ModComponents;
import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.items.Baubles.BottledCloudItem;
import com.jinqinxixi.bountifulbaubles.items.Baubles.BrokenHeartItem;
import com.jinqinxixi.bountifulbaubles.items.Baubles.CrossNecklaceItem;
import com.jinqinxixi.bountifulbaubles.items.Baubles.PhylacteryCharmItem;
import com.jinqinxixi.bountifulbaubles.items.Baubles.WormholeMirrorItem;
import com.jinqinxixi.bountifulbaubles.items.ModCreativeModeTab;
import com.jinqinxixi.bountifulbaubles.items.ModItems;
import com.jinqinxixi.bountifulbaubles.items.ModSounds;
import com.jinqinxixi.bountifulbaubles.items.Potion.ModBrewingRecipes;
import com.jinqinxixi.bountifulbaubles.loot.LootHandler;
import com.jinqinxixi.bountifulbaubles.mobeffects.ModEffects;
import com.jinqinxixi.bountifulbaubles.mobeffects.SinfulEffect;
import com.jinqinxixi.bountifulbaubles.modifier.CurioImpl;
import com.jinqinxixi.bountifulbaubles.network.NetworkHandler;
import com.jinqinxixi.bountifulbaubles.network.TotemNetworkHandler;
import com.jinqinxixi.bountifulbaubles.recast.AnvilRecastRegistry;
import com.jinqinxixi.bountifulbaubles.recast.UnifiedRecipeProvider;
import com.jinqinxixi.bountifulbaubles.wormhole.PacketHandler;
import com.jinqinxixi.bountifulbaubles.wormhole.TeleportRequestManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosCapability;

@Mod(value="bountifulbaubles")
public class BountifulBaublesMod {
    public static final String MOD_ID = "bountifulbaubles";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"bountifulbaubles");
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"bountifulbaubles");
    private static final List<DeferredHolder<Item, ? extends Item>> CURIO_ITEMS = List.of();

    public BountifulBaublesMod(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.register(LootHandler.class);
        modEventBus.addListener(this::onGatherData);
        NeoForge.EVENT_BUS.addListener(ModBrewingRecipes::registerBrewingRecipes);
        ATTRIBUTES.register(modEventBus);
        ModComponents.register(modEventBus);
        NeoForge.EVENT_BUS.register(BottledCloudItem.class);
        modEventBus.addListener(this::registerNetworkHandlers);
        ModEffects.EFFECTS.register(modEventBus);
        modEventBus.addListener(SinfulEffect.ClientEffectHandler::registerExtensions);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_SPEC);
        NeoForge.EVENT_BUS.register(CrossNecklaceItem.class);
        NeoForge.EVENT_BUS.register(BrokenHeartItem.class);
        NeoForge.EVENT_BUS.register(PhylacteryCharmItem.class);
        modEventBus.addListener(this::registerCapabilities);
        ModCreativeModeTab.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModItems.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(PacketHandler::register);
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
    }

    private void registerNetworkHandlers(RegisterPayloadHandlersEvent event) {
        NetworkHandler.register(event);
        TotemNetworkHandler.register(event);
    }

    private void onServerTick(ServerTickEvent.Post event) {
        if (event.getServer().isRunning()) {
            TeleportRequestManager.tick();
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AnvilRecastRegistry.registerAllRecipes();
            ModConfig.loadLootConfig();
        });
    }

    @SubscribeEvent
    public void onGatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new UnifiedRecipeProvider(output, lookupProvider));
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bountiful").requires(source -> source.hasPermission(0))).then(Commands.literal((String)"tp_accept").then(Commands.argument((String)"requestId", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.handleTeleportResponse((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.literal((String)"tp_deny").then(Commands.argument((String)"requestId", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.handleTeleportResponse((CommandContext<CommandSourceStack>)ctx, false)))));
    }

    private int handleTeleportResponse(CommandContext<CommandSourceStack> ctx, boolean accept) {
        Entity entity = ((CommandSourceStack)ctx.getSource()).getEntity();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.players_only").withStyle(ChatFormatting.RED));
            return 0;
        }
        ServerPlayer responder = (ServerPlayer)entity;
        try {
            String requestIdStr = StringArgumentType.getString(ctx, (String)"requestId");
            if (!UUID_PATTERN.matcher(requestIdStr).matches()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"msg.mirror.invalid_format").withStyle(ChatFormatting.RED));
                return 0;
            }
            UUID requestId = UUID.fromString(requestIdStr);
            TeleportRequestManager.TeleportRequest request = TeleportRequestManager.getRequest(requestId);
            if (request == null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"msg.mirror.invalid_request").withStyle(ChatFormatting.RED));
                return 0;
            }
            TeleportRequestManager.removeRequest(requestId);
            if (accept) {
                request.requester.teleportTo(responder.serverLevel(), responder.getX(), responder.getY(), responder.getZ(), responder.getYRot(), responder.getXRot());
                ((WormholeMirrorItem)((Object)ModItems.WORMHOLE_MIRROR.get())).playTeleportEffects(request.requester);
            }
            this.sendTeleportMessages(request.requester, responder, accept);
            return 1;
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"msg.mirror.invalid_request").withStyle(ChatFormatting.RED));
            return 0;
        }
    }

    private void sendTeleportMessages(ServerPlayer requester, ServerPlayer responder, boolean accepted) {
        MutableComponent requesterMsg = accepted ? Component.translatable((String)"msg.mirror.request_accepted", (Object[])new Object[]{responder.getDisplayName()}) : Component.translatable((String)"msg.mirror.request_denied", (Object[])new Object[]{responder.getDisplayName()});
        MutableComponent responderMsg = accepted ? Component.translatable((String)"msg.mirror.accepted", (Object[])new Object[]{requester.getDisplayName()}) : Component.translatable((String)"msg.mirror.denied", (Object[])new Object[]{requester.getDisplayName()});
        requester.sendSystemMessage((Component)requesterMsg);
        responder.sendSystemMessage((Component)responderMsg);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        ModItems.getCurioItems().forEach(item -> event.registerItem(CuriosCapability.ITEM, (stack, context) -> new CurioImpl((ItemStack)stack), new ItemLike[]{(ItemLike)item.get()}));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemPropertyFunction blockFn = (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f;
            ItemProperties.register((Item)((Item)ModItems.COBALT_SHIELD.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"blocking"), (ItemPropertyFunction)blockFn);
            ItemProperties.register((Item)((Item)ModItems.OBSIDIAN_SHIELD.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"blocking"), (ItemPropertyFunction)blockFn);
            ItemProperties.register((Item)((Item)ModItems.ANKH_SHIELD.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"blocking"), (ItemPropertyFunction)blockFn);
        });
    }

    @EventBusSubscriber(modid="bountifulbaubles", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Client Initialized");
        }
    }
}

