/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StackHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ItemParser parser;
    private final DynamicOps<Tag> registryOps;
    private boolean logErrors;

    public StackHelper(HolderLookup.Provider lookupProvider) {
        this(lookupProvider, true);
    }

    public StackHelper(HolderLookup.Provider lookupProvider, boolean logErrors) {
        this.parser = new ItemParser(lookupProvider);
        this.registryOps = lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.logErrors = logErrors;
    }

    public ItemStack parse(String stackString) {
        return StackHelper.parse(stackString, this.parser, ItemStack.EMPTY, this.logErrors);
    }

    public ItemStack parse(String stackString, ItemStack fallback) {
        return StackHelper.parse(stackString, this.parser, fallback, this.logErrors);
    }

    public String encode(ItemStack stack) {
        return StackHelper.encode(stack, this.registryOps);
    }

    public static ItemStack parse(String stackString, RegistryAccess registryAccess) {
        return StackHelper.parse(stackString, registryAccess, ItemStack.EMPTY);
    }

    public static ItemStack parse(String stackString, RegistryAccess registryAccess, ItemStack fallback) {
        return StackHelper.parse(stackString, new ItemParser((HolderLookup.Provider)registryAccess), fallback, true);
    }

    public static ItemStack parse(String stackString, ItemParser parser) {
        return StackHelper.parse(stackString, parser, ItemStack.EMPTY, true);
    }

    public static ItemStack parse(String stackString, ItemParser parser, ItemStack fallback, boolean logErrors) {
        String number;
        int count = 1;
        int comma = stackString.lastIndexOf(44);
        if (comma != -1 && (number = stackString.substring(comma + 1)).matches("-?\\d+(\\d+)?")) {
            count = Integer.parseInt(number);
            stackString = stackString.substring(0, comma);
        }
        try {
            ItemParser.ItemResult result = parser.parse(new StringReader(stackString));
            ItemStack stack = new ItemStack(result.item(), count);
            if (count > stack.getMaxStackSize()) {
                stack.setCount(stack.getMaxStackSize());
            }
            stack.applyComponents(result.components());
            return stack;
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Failed to parse stack string: {}", (Object)stackString, (Object)e);
            return fallback;
        }
    }

    public static String encode(ItemStack stack, RegistryAccess registryAccess) {
        return StackHelper.encode(stack, (DynamicOps<Tag>)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE));
    }

    public static String encode(ItemStack stack, DynamicOps<Tag> registryOps) {
        CompoundTag compound;
        Tag tag;
        Object stackString = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        DataComponentPatch componentPatch = stack.getComponentsPatch();
        if (!componentPatch.isEmpty() && (tag = DataComponentPatch.CODEC.encodeStart(registryOps, (Object)componentPatch).result().orElseGet(CompoundTag::new)) instanceof CompoundTag && !(compound = (CompoundTag)tag).isEmpty()) {
            stackString = (String)stackString + "[" + compound.getAllKeys().stream().map(key -> key + "=" + String.valueOf(compound.get(key))).collect(Collectors.joining(",")) + "]";
        }
        if (stack.getCount() != 1) {
            stackString = (String)stackString + "," + stack.getCount();
        }
        return stackString;
    }
}

