/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class BlockToStackHelper {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static FakePlayer harvester = null;
    public static List<ItemStack> itemCollection = null;

    public static void init() {
        LOCK.lock();
        NeoForge.EVENT_BUS.addListener(BlockToStackHelper::entityJoinWorld);
    }

    public static void entityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ItemEntity && itemCollection != null && !event.isCanceled()) {
            itemCollection.add(((ItemEntity)event.getEntity()).getItem());
            event.setCanceled(true);
        }
    }

    public static List<ItemStack> breakAndCollect(Level world, BlockPos pos) {
        return BlockToStackHelper.breakAndCollectWithPlayer(world, pos, null);
    }

    public static List<ItemStack> breakAndCollectWithPlayer(Level world, BlockPos pos, Player player) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!(world instanceof ServerLevel)) {
            return stacks;
        }
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (player == null) {
            player = BlockToStackHelper.getHarvester((ServerLevel)world);
        }
        itemCollection = new ArrayList<ItemStack>();
        BlockEntity tile = world.getBlockEntity(pos);
        if (state.onDestroyedByPlayer(world, pos, player, true, world.getFluidState(pos))) {
            block.destroy((LevelAccessor)world, pos, state);
            block.playerDestroy(world, player, pos, state, tile, player.getMainHandItem());
        }
        stacks.addAll(itemCollection);
        itemCollection = null;
        return stacks;
    }

    public static void breakAndCollect(Level world, BlockPos pos, InventoryDynamic inventoryDynamic) {
        BlockToStackHelper.breakAndCollectWithPlayer(world, pos, inventoryDynamic, null);
    }

    public static void breakAndCollectWithPlayer(Level world, BlockPos pos, InventoryDynamic inventoryDynamic, Player player) {
        List<ItemStack> stacks = BlockToStackHelper.breakAndCollectWithPlayer(world, pos, player);
        for (ItemStack stack : stacks) {
            if (stack == null || stack.isEmpty()) continue;
            InventoryUtils.insertItem((Container)inventoryDynamic, (ItemStack)stack, (boolean)false);
        }
    }

    public static FakePlayer getHarvester(ServerLevel world) {
        if (harvester == null) {
            harvester = FakePlayerFactory.get((ServerLevel)world, (GameProfile)new GameProfile(UUID.fromString("060e69c4-6aed-11e6-8b77-86f30ca893d3"), "[Brandons-Core]"));
            harvester.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        }
        return harvester;
    }

    public static void startItemCapture() {
        itemCollection = new ArrayList<ItemStack>();
    }

    public static Set<ItemStack> collectAndEndCapture() {
        LinkedHashSet<ItemStack> dropsCopy = new LinkedHashSet<ItemStack>(itemCollection);
        itemCollection = null;
        return dropsCopy;
    }
}

