/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.model;

import java.util.UUID;
import journeymap.api.services.Services;
import journeymap.common.util.PermissionsManager;
import net.minecraft.server.level.ServerPlayer;

public class PlayerDTO {
    private boolean hiddenUnderground;
    private boolean visible;
    private boolean chunkEntity;
    private boolean chunkFull;
    private boolean chunkBlock;
    private boolean chunkInaccessible;
    private final String uuid;

    public PlayerDTO(String uuid) {
        this(uuid, false, true, false, false, false, false);
    }

    public PlayerDTO(String uuid, boolean hiddenUnderground, boolean visible, boolean chunkEntity, boolean chunkFull, boolean chunkBlock, boolean chunkInaccessible) {
        this.uuid = uuid;
        this.hiddenUnderground = hiddenUnderground;
        this.visible = visible;
        this.chunkEntity = chunkEntity;
        this.chunkFull = chunkFull;
        this.chunkBlock = chunkBlock;
        this.chunkInaccessible = chunkInaccessible;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isHiddenUnderground() {
        return this.hiddenUnderground;
    }

    public void setHiddenUnderground(boolean hiddenUnderground) {
        this.hiddenUnderground = hiddenUnderground;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isChunkEntity() {
        return this.chunkEntity;
    }

    public void setChunkEntity(boolean chunkEntity) {
        this.chunkEntity = chunkEntity;
    }

    public boolean isChunkFull() {
        return this.chunkFull;
    }

    public void setChunkFull(boolean chunkFull) {
        this.chunkFull = chunkFull;
    }

    public boolean isChunkBlock() {
        return this.chunkBlock;
    }

    public void setChunkBlock(boolean chunkBlock) {
        this.chunkBlock = chunkBlock;
    }

    public boolean isChunkInaccessible() {
        return this.chunkInaccessible;
    }

    public void setChunkInaccessible(boolean chunkInaccessible) {
        this.chunkInaccessible = chunkInaccessible;
    }

    public boolean viewChunkEntity() {
        ServerPlayer player = Services.COMMON_SERVICE.getServer().getPlayerList().getPlayer(UUID.fromString(this.uuid));
        return this.chunkEntity && PermissionsManager.getInstance().canServerAdmin(player);
    }

    public boolean viewChunkFull() {
        ServerPlayer player = Services.COMMON_SERVICE.getServer().getPlayerList().getPlayer(UUID.fromString(this.uuid));
        return this.chunkFull && PermissionsManager.getInstance().canServerAdmin(player);
    }

    public boolean viewChunkBlock() {
        ServerPlayer player = Services.COMMON_SERVICE.getServer().getPlayerList().getPlayer(UUID.fromString(this.uuid));
        return this.chunkBlock && PermissionsManager.getInstance().canServerAdmin(player);
    }

    public boolean viewChunkInaccessible() {
        ServerPlayer player = Services.COMMON_SERVICE.getServer().getPlayerList().getPlayer(UUID.fromString(this.uuid));
        return this.chunkInaccessible && PermissionsManager.getInstance().canServerAdmin(player);
    }
}

