/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.generation.recipes.AbstractType;
import fr.samlegamer.addonslib.generation.recipes.mat.McwStoneMat;
import fr.samlegamer.addonslib.generation.recipes.mat.McwWoodMat;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

class Fences
extends AbstractType {
    private static final String id = "mcwfences";

    public Fences(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries, String modid, String originalMod) {
        super(pOutput, pRegistries, modid, originalMod, id);
    }

    private void wood_variants(RecipeOutput consumer, String mat, Block log, Block planks) {
        Block curved_gate = Finder.findBlock(this.modid, mat + "_curved_gate");
        Block highley_gate = Finder.findBlock(this.modid, mat + "_highley_gate");
        Block horse_fence = Finder.findBlock(this.modid, mat + "_horse_fence");
        Block picket_fence = Finder.findBlock(this.modid, mat + "_picket_fence");
        Block pyramid_gate = Finder.findBlock(this.modid, mat + "_pyramid_gate");
        Block stockade_fence = Finder.findBlock(this.modid, mat + "_stockade_fence");
        Block wired_fence = Finder.findBlock(this.modid, mat + "_wired_fence");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"B A", "BAA"}, (ItemLike)curved_gate, 4, (ItemLike)planks, (ItemLike)log, "curved_gate");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"ABA", "ABA"}, (ItemLike)highley_gate, 1, (ItemLike)Items.STICK, (ItemLike)log, "highley");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"ABA", "BAB"}, (ItemLike)horse_fence, 3, (ItemLike)log, (ItemLike)Items.STICK, "horse");
        this.mcwRecipes.mkRpW3Items(consumer, (ItemLike)planks, new String[]{"CBC", "CAC"}, (ItemLike)picket_fence, 3, (ItemLike)Items.STICK, (ItemLike)planks, (ItemLike)log, "picket");
        this.mcwRecipes.mkRpW3Items(consumer, (ItemLike)planks, new String[]{"ABA", "ACA"}, (ItemLike)pyramid_gate, 1, (ItemLike)Items.STICK, (ItemLike)log, (ItemLike)planks, "pyramid");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"ABA", "BAB"}, (ItemLike)stockade_fence, 3, (ItemLike)log, (ItemLike)planks, "stockade");
        this.mcwRecipes.mkRpW3Items(consumer, (ItemLike)planks, new String[]{"ACA", "ABA"}, (ItemLike)wired_fence, 3, (ItemLike)Items.STICK, (ItemLike)log, (ItemLike)Blocks.IRON_BARS, "wired");
    }

    private void hedge(RecipeOutput consumer, Block hedge, Block leave) {
        this.mcwRecipes.mkRpW1Item(consumer, (ItemLike)leave, new String[]{"AA", "AA"}, (ItemLike)hedge, 4, (ItemLike)leave, "hedge");
    }

    private void stone_variants(RecipeOutput consumer, String mat, Block stone, Block smoothStone) {
        Block modern_wall = Finder.findBlock(this.modid, "modern_" + mat + "_wall");
        Block railing_wall = Finder.findBlock(this.modid, "railing_" + mat + "_wall");
        Block grass_topped_wall = Finder.findBlock(this.modid, mat + "_grass_topped_wall");
        Block pillar_wall = Finder.findBlock(this.modid, mat + "_pillar_wall");
        Block railing_gate = Finder.findBlock(this.modid, mat + "_railing_gate");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)stone, new String[]{"ABA", "AAA"}, (ItemLike)modern_wall, 6, (ItemLike)smoothStone, (ItemLike)stone, "modern");
        this.mcwRecipes.mkScW1Item(consumer, (ItemLike)modern_wall, (ItemLike)stone);
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)stone, new String[]{"ABA", "AAA"}, (ItemLike)railing_wall, 6, (ItemLike)smoothStone, (ItemLike)Blocks.IRON_BARS, "railing_wall");
        this.mcwRecipes.mkScW1Item(consumer, (ItemLike)railing_wall, (ItemLike)stone);
        this.mcwRecipes.mkRpW3Items(consumer, (ItemLike)stone, new String[]{"BCB", "AAA"}, (ItemLike)grass_topped_wall, 6, (ItemLike)smoothStone, (ItemLike)stone, (ItemLike)Blocks.DIRT, "grass_topped");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)stone, new String[]{"AAA", "B B"}, (ItemLike)pillar_wall, 5, (ItemLike)smoothStone, (ItemLike)stone, "pillarwall");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)stone, new String[]{"ABA", "ABA"}, (ItemLike)railing_gate, 1, (ItemLike)Blocks.IRON_BARS, (ItemLike)stone, "railing_gate");
        this.mcwRecipes.mkScW1Item(consumer, (ItemLike)railing_gate, (ItemLike)stone);
    }

    @Override
    public void buildWood(RecipeOutput consumer, List<String> MAT, List<McwWoodMat> woodMat) {
        if (MAT.size() == woodMat.size()) {
            for (int i = 0; i < MAT.size(); ++i) {
                Block log = woodMat.get(i).getLog();
                Block planks = woodMat.get(i).getPlanks();
                this.wood_variants(consumer, MAT.get(i), log, planks);
            }
        }
    }

    @Override
    public void buildStone(RecipeOutput consumer, List<String> MAT, List<McwStoneMat> stoneMat) {
        if (MAT.size() == stoneMat.size()) {
            for (int i = 0; i < MAT.size(); ++i) {
                this.stone_variants(consumer, MAT.get(i), stoneMat.get(i).getStoneBase(), stoneMat.get(i).getSmoothStone());
            }
        }
    }

    @Override
    public void buildHedge(RecipeOutput consumer, List<String> MAT, List<Block> leave) {
        if (MAT.size() == leave.size()) {
            for (int i = 0; i < MAT.size(); ++i) {
                Block hedge = Finder.findBlock(this.modid, MAT.get(i) + "_hedge");
                this.hedge(consumer, hedge, leave.get(i));
            }
        }
    }
}

