/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import com.mojang.datafixers.DSL;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;
import sonar.fluxnetworks.api.FluxCapabilities;
import sonar.fluxnetworks.common.device.TileFluxConnector;
import sonar.fluxnetworks.common.device.TileFluxController;
import sonar.fluxnetworks.common.device.TileFluxPlug;
import sonar.fluxnetworks.common.device.TileFluxPoint;
import sonar.fluxnetworks.common.device.TileFluxStorage;
import sonar.fluxnetworks.register.RegistryBlocks;

public class RegistryBlockEntityTypes {
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileFluxPlug>> FLUX_PLUG = RegistryBlockEntityTypes.holder(RegistryBlocks.FLUX_PLUG_KEY);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileFluxPoint>> FLUX_POINT = RegistryBlockEntityTypes.holder(RegistryBlocks.FLUX_POINT_KEY);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileFluxController>> FLUX_CONTROLLER = RegistryBlockEntityTypes.holder(RegistryBlocks.FLUX_CONTROLLER_KEY);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileFluxStorage.Basic>> BASIC_FLUX_STORAGE = RegistryBlockEntityTypes.holder(RegistryBlocks.BASIC_FLUX_STORAGE_KEY);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileFluxStorage.Herculean>> HERCULEAN_FLUX_STORAGE = RegistryBlockEntityTypes.holder(RegistryBlocks.HERCULEAN_FLUX_STORAGE_KEY);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileFluxStorage.Gargantuan>> GARGANTUAN_FLUX_STORAGE = RegistryBlockEntityTypes.holder(RegistryBlocks.GARGANTUAN_FLUX_STORAGE_KEY);

    static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> holder(ResourceLocation location) {
        return DeferredHolder.create((ResourceKey)BuiltInRegistries.BLOCK_ENTITY_TYPE.key(), (ResourceLocation)location);
    }

    static void register(RegisterEvent.RegisterHelper<BlockEntityType<?>> helper) {
        helper.register(RegistryBlocks.FLUX_PLUG_KEY, (Object)new BlockEntityType(TileFluxPlug::new, Set.of((Block)RegistryBlocks.FLUX_PLUG.get()), DSL.remainderType()));
        helper.register(RegistryBlocks.FLUX_POINT_KEY, (Object)new BlockEntityType(TileFluxPoint::new, Set.of((Block)RegistryBlocks.FLUX_POINT.get()), DSL.remainderType()));
        helper.register(RegistryBlocks.FLUX_CONTROLLER_KEY, (Object)new BlockEntityType(TileFluxController::new, Set.of((Block)RegistryBlocks.FLUX_CONTROLLER.get()), DSL.remainderType()));
        helper.register(RegistryBlocks.BASIC_FLUX_STORAGE_KEY, (Object)new BlockEntityType(TileFluxStorage.Basic::new, Set.of((Block)RegistryBlocks.BASIC_FLUX_STORAGE.get()), DSL.remainderType()));
        helper.register(RegistryBlocks.HERCULEAN_FLUX_STORAGE_KEY, (Object)new BlockEntityType(TileFluxStorage.Herculean::new, Set.of((Block)RegistryBlocks.HERCULEAN_FLUX_STORAGE.get()), DSL.remainderType()));
        helper.register(RegistryBlocks.GARGANTUAN_FLUX_STORAGE_KEY, (Object)new BlockEntityType(TileFluxStorage.Gargantuan::new, Set.of((Block)RegistryBlocks.GARGANTUAN_FLUX_STORAGE.get()), DSL.remainderType()));
    }

    static void registerBlockCapabilities(RegisterCapabilitiesEvent event) {
        RegistryBlockEntityTypes.registerEnergyCapabilities(event, (BlockEntityType<? extends TileFluxConnector>)((BlockEntityType)FLUX_PLUG.get()));
        RegistryBlockEntityTypes.registerEnergyCapabilities(event, (BlockEntityType<? extends TileFluxConnector>)((BlockEntityType)FLUX_POINT.get()));
    }

    static void registerEnergyCapabilities(RegisterCapabilitiesEvent event, BlockEntityType<? extends TileFluxConnector> blockEntityType) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, (blockEntity, side) -> (IEnergyStorage)blockEntity.getEnergyCapability(Capabilities.EnergyStorage.BLOCK, (Direction)side));
        event.registerBlockEntity(FluxCapabilities.BLOCK, blockEntityType, (blockEntity, side) -> blockEntity.getEnergyCapability(FluxCapabilities.BLOCK, (Direction)side));
    }

    private RegistryBlockEntityTypes() {
    }
}

