/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import javax.annotation.Nonnull;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.client.FluxColorHandler;
import sonar.fluxnetworks.client.gui.GuiFluxAdminHome;
import sonar.fluxnetworks.client.gui.GuiFluxDeviceHome;
import sonar.fluxnetworks.client.mui.MUIIntegration;
import sonar.fluxnetworks.client.render.FluxStorageEntityRenderer;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.ClientMessages;
import sonar.fluxnetworks.register.RegistryBlockEntityTypes;
import sonar.fluxnetworks.register.RegistryBlocks;
import sonar.fluxnetworks.register.RegistryItems;
import sonar.fluxnetworks.register.RegistryMenuTypes;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="fluxnetworks", bus=EventBusSubscriber.Bus.MOD)
public class ClientRegistration {
    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        Channel.get().setS2CMessageHandler((index, payload, context) -> ClientMessages.msg(index, payload, () -> (LocalPlayer)context.player(), context.listener().getMainThreadEventLoop()));
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        if (FluxNetworks.isModernUILoaded()) {
            event.register((MenuType)RegistryMenuTypes.FLUX_MENU.get(), MUIIntegration.upgradeScreenFactory(ClientRegistration.getScreenFactory()));
        } else {
            event.register((MenuType)RegistryMenuTypes.FLUX_MENU.get(), ClientRegistration.getScreenFactory());
        }
    }

    @Nonnull
    private static MenuScreens.ScreenConstructor<FluxMenu, AbstractContainerScreen<FluxMenu>> getScreenFactory() {
        return (menu, inventory, title) -> {
            if (menu.mProvider instanceof TileFluxDevice) {
                return new GuiFluxDeviceHome((FluxMenu)menu, inventory.player);
            }
            return new GuiFluxAdminHome((FluxMenu)menu, inventory.player);
        };
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)RegistryBlockEntityTypes.BASIC_FLUX_STORAGE.get(), FluxStorageEntityRenderer.PROVIDER);
        event.registerBlockEntityRenderer((BlockEntityType)RegistryBlockEntityTypes.HERCULEAN_FLUX_STORAGE.get(), FluxStorageEntityRenderer.PROVIDER);
        event.registerBlockEntityRenderer((BlockEntityType)RegistryBlockEntityTypes.GARGANTUAN_FLUX_STORAGE.get(), FluxStorageEntityRenderer.PROVIDER);
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(@Nonnull RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)FluxColorHandler.INSTANCE, new ItemLike[]{(ItemLike)RegistryBlocks.FLUX_CONTROLLER.get(), (ItemLike)RegistryBlocks.FLUX_POINT.get(), (ItemLike)RegistryBlocks.FLUX_PLUG.get()});
        event.register(FluxColorHandler::colorMultiplierForConfigurator, new ItemLike[]{(ItemLike)RegistryItems.FLUX_CONFIGURATOR.get()});
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(@Nonnull RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)FluxColorHandler.INSTANCE, new Block[]{(Block)RegistryBlocks.FLUX_CONTROLLER.get(), (Block)RegistryBlocks.FLUX_POINT.get(), (Block)RegistryBlocks.FLUX_PLUG.get(), (Block)RegistryBlocks.BASIC_FLUX_STORAGE.get(), (Block)RegistryBlocks.HERCULEAN_FLUX_STORAGE.get(), (Block)RegistryBlocks.GARGANTUAN_FLUX_STORAGE.get()});
    }
}

