/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.client.FluxColorHandler;
import sonar.fluxnetworks.client.render.FluxStorageEntityRenderer;
import sonar.fluxnetworks.client.render.FluxStorageRenderType;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.common.util.FluxUtils;

@OnlyIn(value=Dist.CLIENT)
public class FluxStorageItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public FluxStorageItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext transformType, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int color = FluxColorHandler.getColorForItem(stack);
        Long storedEnergy = (Long)stack.get(FluxDataComponents.STORED_ENERGY);
        long energy = storedEnergy != null ? storedEnergy : 0L;
        FluxStorageBlock block = (FluxStorageBlock)Block.byItem((Item)stack.getItem());
        BlockState renderState = block.defaultBlockState();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = dispatcher.getBlockModel(renderState);
        float r = FluxUtils.getRed(color);
        float g = FluxUtils.getGreen(color);
        float b = FluxUtils.getBlue(color);
        dispatcher.getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(Sheets.cutoutBlockSheet()), renderState, model, r, g, b, packedLight, packedOverlay, ModelData.EMPTY, null);
        FluxStorageEntityRenderer.render(poseStack, bufferSource.getBuffer(FluxStorageRenderType.getType()), color, packedOverlay, energy, block.getEnergyCapacity());
    }
}

