/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabEditAbstract;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiTabSettings
extends GuiTabEditAbstract {
    public SimpleButton mDelete;
    public SimpleButton mApply;
    public int mDeleteCount;

    public GuiTabSettings(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mSecurityLevel = this.getNetwork().getSecurityLevel();
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_SETTING;
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (this.getNetwork().isValid()) {
            if (this.mDelete.isMouseHovered(mouseX, mouseY)) {
                if (this.mDelete.isClickable()) {
                    gr.drawCenteredString(this.font, String.valueOf(ChatFormatting.BOLD) + FluxTranslate.DELETE_NETWORK.get(), this.mDelete.x + this.mDelete.width / 2, this.mDelete.y - 12, 0xFF0000);
                } else {
                    gr.drawCenteredString(this.font, FluxTranslate.DOUBLE_SHIFT.get(), this.mDelete.x + this.mDelete.width / 2, this.mDelete.y - 12, 0xFFFFFF);
                }
            }
        } else {
            this.renderNavigationPrompt(gr, FluxTranslate.ERROR_NO_SELECTED, EnumNavigationTab.TAB_SELECTION);
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.getNetwork().isValid()) {
            this.mNetworkName.setValue(this.getNetwork().getNetworkName());
            this.mDelete = new SimpleButton(this, this.leftPos + this.imageWidth / 2 - 12 - 48, this.topPos + 150, 48, 12, FluxTranslate.DELETE.get(), -43691);
            this.mDelete.setClickable(false);
            this.mButtons.add(this.mDelete);
            this.mApply = new SimpleButton(this, this.leftPos + this.imageWidth / 2 + 12, this.topPos + 150, 48, 12, FluxTranslate.APPLY.get());
            this.mApply.setClickable(false);
            this.mButtons.add(this.mApply);
            boolean colorSet = false;
            for (int i = 0; i < EnumNetworkColor.VALUES.length; ++i) {
                EnumNetworkColor color = EnumNetworkColor.VALUES[i];
                ColorButton button = new ColorButton(this, this.leftPos + 48 + i % 7 * 16, this.topPos + 87 + i / 7 * 16, color.getRGB());
                if (!colorSet && color.getRGB() == this.getNetwork().getNetworkColor()) {
                    this.mColorButton = button;
                    button.setSelected(true);
                    colorSet = true;
                }
                this.mButtons.add(button);
            }
            if (!colorSet) {
                ColorButton button;
                this.mColorButton = button = new ColorButton(this, this.leftPos + 32, this.topPos + 107, this.getNetwork().getNetworkColor());
                button.setSelected(true);
                this.mButtons.add(button);
            }
        }
    }

    @Override
    public void onEditSettingsChanged() {
        if (this.mApply != null) {
            boolean clickable = true;
            if (this.getNetwork().getSecurityLevel() != SecurityLevel.ENCRYPTED && this.mSecurityLevel == SecurityLevel.ENCRYPTED) {
                clickable = !this.mPassword.getValue().isEmpty();
            }
            this.mApply.setClickable(clickable && !this.mNetworkName.getValue().isEmpty());
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (button == this.mApply) {
                ClientMessages.editNetwork(this.getToken(), this.getNetwork(), this.mNetworkName.getValue(), this.mColorButton.mColor, this.mSecurityLevel, this.mPassword.getValue());
                this.mApply.setClickable(false);
            } else if (button == this.mDelete) {
                ClientMessages.deleteNetwork(this.getToken(), this.getNetwork());
                this.mDeleteCount = 0;
                this.mDelete.setClickable(false);
            }
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!this.getNetwork().isValid()) {
            return this.redirectNavigationPrompt(mouseX, mouseY, mouseButton, EnumNavigationTab.TAB_SELECTION);
        }
        return false;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.mDelete != null && this.getFocused() == null) {
            if ((modifiers & 1) != 0) {
                ++this.mDeleteCount;
                if (this.mDeleteCount > 1) {
                    this.mDelete.setClickable(true);
                }
            } else {
                this.mDeleteCount = 0;
                this.mDelete.setClickable(false);
            }
        }
        return super.onKeyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (code == 1) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
            return;
        }
        if (code == -1 && key == 2) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
        }
    }
}

