/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.popup;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.client.gui.button.Checkbox;
import sonar.fluxnetworks.client.gui.button.FluxEditBox;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.button.SwitchButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabConnections;
import sonar.fluxnetworks.register.ClientMessages;

public class PopupConnectionEdit
extends GuiPopupCore<GuiTabConnections> {
    public SimpleButton mCancel;
    public SimpleButton mApply;
    public FluxEditBox mCustomName;
    public FluxEditBox mPriority;
    public FluxEditBox mLimit;
    public SwitchButton mSurgeMode;
    public SwitchButton mDisableLimit;
    public SwitchButton mChunkLoading;
    public Checkbox mEditCustomName;
    public Checkbox mEditPriority;
    public Checkbox mEditLimit;
    public Checkbox mEditSurgeMode;
    public Checkbox mEditDisableLimit;
    public Checkbox mEditChunkLoading;

    public PopupConnectionEdit(GuiTabConnections host) {
        super(host);
    }

    @Override
    public void init() {
        super.init();
        this.mCancel = new SimpleButton(this, this.leftPos + this.imageWidth / 2 - 12 - 48, this.topPos + 146, 48, 12, FluxTranslate.CANCEL.get());
        this.mButtons.add(this.mCancel);
        this.mApply = new SimpleButton(this, this.leftPos + this.imageWidth / 2 + 12, this.topPos + 146, 48, 12, FluxTranslate.APPLY.get());
        this.mApply.setClickable(false);
        this.mButtons.add(this.mApply);
        int color = ((GuiTabConnections)this.mHost).getNetwork().getNetworkColor() | 0xFF000000;
        IFluxDevice singleConnection = ((GuiTabConnections)this.mHost).mSelected.size() == 1 ? (IFluxDevice)((GuiTabConnections)this.mHost).mSelected.iterator().next() : null;
        this.mCustomName = FluxEditBox.create(FluxTranslate.NAME.get() + ": ", this.font, this.leftPos + 20, this.topPos + 30, 136, 12).setOutlineColor(color);
        this.mCustomName.setMaxLength(24);
        if (singleConnection != null) {
            this.mCustomName.setValue(singleConnection.getCustomName());
        }
        this.addRenderableWidget((GuiEventListener)this.mCustomName);
        this.mPriority = FluxEditBox.create(FluxTranslate.PRIORITY.get() + ": ", this.font, this.leftPos + 20, this.topPos + 47, 136, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
        this.mPriority.setMaxLength(5);
        if (singleConnection != null) {
            this.mPriority.setValue(Integer.toString(singleConnection.getRawPriority()));
        } else {
            this.mPriority.setValue(Integer.toString(0));
        }
        this.addRenderableWidget((GuiEventListener)this.mPriority);
        this.mLimit = FluxEditBox.create(FluxTranslate.TRANSFER_LIMIT.get() + ": ", this.font, this.leftPos + 20, this.topPos + 64, 136, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(Long.MAX_VALUE);
        this.mLimit.setMaxLength(15);
        if (singleConnection != null) {
            this.mLimit.setValue(Long.toString(singleConnection.getRawLimit()));
        } else {
            this.mLimit.setValue(Integer.toString(0));
        }
        this.addRenderableWidget((GuiEventListener)this.mLimit);
        this.mEditCustomName = new Checkbox(this, this.leftPos + 10, this.topPos + 33);
        this.mEditPriority = new Checkbox(this, this.leftPos + 10, this.topPos + 50);
        this.mEditLimit = new Checkbox(this, this.leftPos + 10, this.topPos + 67);
        this.mEditSurgeMode = new Checkbox(this, this.leftPos + 10, this.topPos + 83);
        this.mEditDisableLimit = new Checkbox(this, this.leftPos + 10, this.topPos + 95);
        this.mEditChunkLoading = new Checkbox(this, this.leftPos + 10, this.topPos + 107);
        this.mButtons.add(this.mEditCustomName);
        this.mButtons.add(this.mEditPriority);
        this.mButtons.add(this.mEditLimit);
        this.mButtons.add(this.mEditSurgeMode);
        this.mButtons.add(this.mEditDisableLimit);
        this.mButtons.add(this.mEditChunkLoading);
        this.mSurgeMode = new SwitchButton((GuiFocusable)this, this.leftPos + 140, this.topPos + 82, singleConnection != null && singleConnection.getSurgeMode(), color);
        this.mDisableLimit = new SwitchButton((GuiFocusable)this, this.leftPos + 140, this.topPos + 94, singleConnection != null && singleConnection.getDisableLimit(), color);
        this.mChunkLoading = new SwitchButton((GuiFocusable)this, this.leftPos + 140, this.topPos + 106, singleConnection != null && singleConnection.isForcedLoading(), color);
        this.mChunkLoading.setClickable(FluxConfig.enableChunkLoading && (singleConnection == null || !singleConnection.getDeviceType().isStorage()));
        this.mButtons.add(this.mSurgeMode);
        this.mButtons.add(this.mDisableLimit);
        this.mButtons.add(this.mChunkLoading);
    }

    @Override
    public void drawForegroundLayer(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        gr.drawCenteredString(this.font, FluxTranslate.BATCH_EDIT.get(), this.leftPos + 88, this.topPos + 14, 0xFFFFFF);
        gr.drawCenteredString(this.font, FluxTranslate.EDITING_CONNECTIONS.format(((GuiTabConnections)this.mHost).mSelected.size()), this.leftPos + 88, this.topPos + 122, 0xFFFFFF);
        gr.drawString(this.font, FluxTranslate.SURGE_MODE.get(), this.leftPos + 20, this.topPos + 82, ((GuiTabConnections)this.mHost).getNetwork().getNetworkColor());
        gr.drawString(this.font, FluxTranslate.DISABLE_LIMIT.get(), this.leftPos + 20, this.topPos + 94, ((GuiTabConnections)this.mHost).getNetwork().getNetworkColor());
        if (this.mChunkLoading != null) {
            gr.drawString(this.font, FluxTranslate.CHUNK_LOADING.get(), this.leftPos + 20, this.topPos + 106, ((GuiTabConnections)this.mHost).getNetwork().getNetworkColor());
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        if (button instanceof SwitchButton) {
            SwitchButton switchButton = (SwitchButton)button;
            switchButton.toggle();
        } else if (button instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)button;
            checkbox.toggle();
            this.mApply.setClickable(this.mButtons.stream().filter(b -> b instanceof Checkbox).anyMatch(t -> ((Checkbox)t).isChecked()));
        }
        if (button == this.mCancel) {
            ((GuiTabConnections)this.mHost).closePopup();
        } else if (button == this.mApply) {
            List<GlobalPos> list = ((GuiTabConnections)this.mHost).mSelected.stream().map(IFluxDevice::getGlobalPos).collect(Collectors.toList());
            CompoundTag tag = new CompoundTag();
            if (this.mEditCustomName.isChecked()) {
                tag.putString("custom_name", this.mCustomName.getValue());
            }
            if (this.mEditPriority.isChecked()) {
                int priority = Mth.clamp((int)this.mPriority.getValidInt(), (int)-9999, (int)9999);
                tag.putInt("priority", priority);
            }
            if (this.mEditLimit.isChecked()) {
                long limit = this.mLimit.getValidLong();
                tag.putLong("limit", limit);
            }
            if (this.mEditSurgeMode.isChecked()) {
                tag.putBoolean("surge_mode", this.mSurgeMode.isChecked());
            }
            if (this.mEditDisableLimit.isChecked()) {
                tag.putBoolean("disable_limit", this.mDisableLimit.isChecked());
            }
            if (this.mEditChunkLoading.isChecked()) {
                tag.putBoolean("forced_loading", this.mChunkLoading.isChecked());
            }
            ClientMessages.editConnection(((GuiTabConnections)this.mHost).getToken(), ((GuiTabConnections)this.mHost).getNetwork(), list, tag);
            this.mApply.setClickable(false);
        }
    }
}

