/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;

public class EditButton
extends GuiButtonCore {
    private final int mCheckU0;
    private final int mUncheckU0;
    private final String mCheckText;
    private final String mUncheckText;
    private boolean mChecked = false;

    public EditButton(GuiFocusable screen, int x, int y, int checkU0, int uncheckU0, String checkText, String uncheckText) {
        this(screen, x, y, 10, 10, checkU0, uncheckU0, checkText, uncheckText);
    }

    public EditButton(GuiFocusable screen, int x, int y, int width, int height, int checkU0, int uncheckU0, String checkText, String uncheckText) {
        super(screen, x, y, width, height);
        this.mCheckU0 = checkU0;
        this.mUncheckU0 = uncheckU0;
        this.mCheckText = checkText;
        this.mUncheckText = uncheckText;
    }

    @Override
    protected void drawButton(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        boolean hovered = this.isMouseHovered(mouseX, mouseY);
        if (this.mClickable) {
            if (hovered) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.35f, (float)0.35f, (float)0.35f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GuiFocusable.ICON);
        GuiFocusable.blitF(gr, this.x, this.y, this.width, this.height, this.mChecked ? (float)this.mCheckU0 : (float)this.mUncheckU0, 256.0f, 64.0f, 64.0f);
        if (hovered && this.mClickable) {
            gr.drawCenteredString(this.screen.getMinecraft().font, this.mChecked ? this.mCheckText : this.mUncheckText, this.x + this.width / 2, this.y - 9, -1);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void toggle() {
        this.mChecked = !this.mChecked;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
    }
}

