/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.registry;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.blay09.mods.craftingtweaks.registry.DataDrivenGridFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModFileJsonCompatLoader {
    private static final Logger logger = LoggerFactory.getLogger(ModFileJsonCompatLoader.class);
    private static final Gson gson = new Gson();
    private static final List<CraftingGridProvider> providersFromModFiles = new ArrayList<CraftingGridProvider>();

    public static void load() {
        for (CraftingGridProvider providersFromDataPack : providersFromModFiles) {
            CraftingTweaksAPI.unregisterCraftingGridProvider(providersFromDataPack);
        }
        providersFromModFiles.clear();
        Map modPaths = Balm.lookupAllModPaths((String)"craftingtweaks/grids");
        modPaths.entrySet().forEach(entry -> {
            try (Stream<Path> walker = Files.walk((Path)entry.getValue(), new FileVisitOption[0]);){
                walker.forEach(file -> {
                    if (file.toString().endsWith(".json")) {
                        try (BufferedReader reader = Files.newBufferedReader(file);){
                            CraftingGridProvider gridProvider = ModFileJsonCompatLoader.load((String)entry.getKey(), (CraftingTweaksRegistrationData)gson.fromJson((Reader)reader, CraftingTweaksRegistrationData.class));
                            if (gridProvider != null) {
                                providersFromModFiles.add(gridProvider);
                            }
                        }
                        catch (IOException e) {
                            logger.error("Failed to load CraftingTweaks file {}", file, (Object)e);
                        }
                    }
                });
            }
            catch (IOException e) {
                logger.error("Failed to load CraftingTweaks files from mod {}", entry.getKey(), (Object)e);
            }
        });
    }

    private static boolean isCompatEnabled(String modId) {
        return !CraftingTweaksConfig.getActive().client.disabledAddons.contains(modId);
    }

    private static CraftingGridProvider load(String resourceId, CraftingTweaksRegistrationData data) {
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !Balm.isModLoaded((String)modId) || !ModFileJsonCompatLoader.isCompatEnabled(modId) || !data.isEnabled()) {
            return null;
        }
        CraftingGridProvider gridProvider = DataDrivenGridFactory.createGridProvider(data);
        if (gridProvider != null) {
            CraftingTweaksAPI.registerCraftingGridProvider(gridProvider);
            logger.info("Mod file {} has registered {} of {} with CraftingTweaks", new Object[]{resourceId, data.getContainerClass(), modId});
        }
        return gridProvider;
    }
}

