/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.frqnny.mostructures.init.ProcessorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class SimpleStoneStructureProcessor
extends StructureProcessor {
    public static final MapCodec<SimpleStoneStructureProcessor> CODEC = RecordCodecBuilder.mapCodec(proc -> proc.group((App)Codec.FLOAT.fieldOf("mossiness").forGetter(processor -> Float.valueOf(processor.mossiness))).apply((Applicative)proc, SimpleStoneStructureProcessor::new));
    private final float mossiness;

    public SimpleStoneStructureProcessor(float mossiness) {
        this.mossiness = mossiness;
    }

    private static BlockState randomStairProperties(RandomSource random, Block stairs) {
        return (BlockState)((BlockState)stairs.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(random))).setValue((Property)StairBlock.HALF, (Comparable)Half.values()[random.nextInt(Half.values().length)]);
    }

    private static BlockState randomState(RandomSource random, BlockState[] states) {
        return states[random.nextInt(states.length)];
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlacementData) {
        RandomSource random = structurePlacementData.getRandom(structureBlockInfo2.pos());
        BlockState blockState = structureBlockInfo2.state();
        BlockPos blockPos2 = structureBlockInfo2.pos();
        BlockState blockState2 = null;
        if (blockState.is(Blocks.STONE_BRICKS) || blockState.is(Blocks.STONE) || blockState.is(Blocks.CHISELED_STONE_BRICKS)) {
            blockState2 = this.processBlocks(random);
        }
        return blockState2 != null ? new StructureTemplate.StructureBlockInfo(blockPos2, blockState2, structureBlockInfo2.nbt()) : structureBlockInfo2;
    }

    @Nullable
    private BlockState processBlocks(RandomSource random) {
        if (random.nextFloat() >= 0.5f) {
            return null;
        }
        BlockState[] blockStates = new BlockState[]{Blocks.CRACKED_STONE_BRICKS.defaultBlockState(), SimpleStoneStructureProcessor.randomStairProperties(random, Blocks.STONE_BRICK_STAIRS)};
        BlockState[] blockStates2 = new BlockState[]{Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), SimpleStoneStructureProcessor.randomStairProperties(random, Blocks.MOSSY_STONE_BRICK_STAIRS)};
        return this.process(random, blockStates, blockStates2);
    }

    private BlockState process(RandomSource random, BlockState[] regularStates, BlockState[] mossyStates) {
        return random.nextFloat() < this.mossiness ? SimpleStoneStructureProcessor.randomState(random, mossyStates) : SimpleStoneStructureProcessor.randomState(random, regularStates);
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ProcessorTypes.SIMPLE_STONE.get();
    }
}

