/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.clientbound;

import com.aetherteam.aether.perk.data.ClientMoaSkinPerkData;
import com.aetherteam.aether.perk.types.MoaData;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class ClientMoaSkinPacket {

    public record Sync(Map<UUID, MoaData> moaSkinsData) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Sync> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"sync_moa_skin"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Sync> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)UUIDUtil.STREAM_CODEC, MoaData.STREAM_CODEC), Sync::moaSkinsData, Sync::new);

        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }

        public static void execute(Sync payload, IPayloadContext context) {
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && payload.moaSkinsData() != null && !payload.moaSkinsData().isEmpty()) {
                for (Map.Entry<UUID, MoaData> moaSkinsDataEntry : payload.moaSkinsData().entrySet()) {
                    ClientMoaSkinPerkData.INSTANCE.applyPerk(moaSkinsDataEntry.getKey(), moaSkinsDataEntry.getValue());
                }
            }
        }
    }

    public record Remove(UUID playerUUID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Remove> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"remove_moa_skin"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Remove> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Remove::playerUUID, Remove::new);

        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }

        public static void execute(Remove payload, IPayloadContext context) {
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && payload.playerUUID() != null) {
                ClientMoaSkinPerkData.INSTANCE.removePerk(payload.playerUUID());
            }
        }
    }

    public record Apply(UUID playerUUID, MoaData moaSkinData) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Apply> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"apply_moa_skin"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Apply> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Apply::playerUUID, MoaData.STREAM_CODEC, Apply::moaSkinData, Apply::new);

        public CustomPacketPayload.Type<Apply> type() {
            return TYPE;
        }

        public static void execute(Apply payload, IPayloadContext context) {
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && payload.playerUUID() != null && payload.moaSkinData() != null) {
                ClientMoaSkinPerkData.INSTANCE.applyPerk(payload.playerUUID(), payload.moaSkinData());
            }
        }
    }
}

