/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.player.layer;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.model.ValkyrieWingsModel;
import com.aetherteam.aether.item.EquipmentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class PlayerWingsLayer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation VALKYRIE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/valkyrie/valkyrie.png");
    private final ValkyrieWingsModel<Player> wings;

    public PlayerWingsLayer(RenderLayerParent<T, M> entityRenderer, EntityModelSet modelSet) {
        super(entityRenderer);
        this.wings = new ValkyrieWingsModel(modelSet.bakeLayer(AetherModelLayers.VALKYRIE_ARMOR_WINGS));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (EquipmentUtil.hasFullValkyrieSet(entity)) {
            AetherPlayerAttachment data = (AetherPlayerAttachment)entity.getData(AetherDataAttachments.AETHER_PLAYER);
            this.setupWingRotation(entity, Mth.lerp((float)partialTicks, (float)data.getWingRotationO(), (float)data.getWingRotation()));
            VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)VALKYRIE_TEXTURE));
            this.wings.renderToBuffer(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }

    public void setupWingRotation(T entity, float sinage) {
        sinage = !(entity.onGround() || entity.isInFluidType() || entity.getVehicle() == null || entity.getVehicle().onGround()) ? (sinage *= 1.5f) : (sinage *= 0.3f);
        this.wings.rightWing.yRot = 0.4f;
        this.wings.rightWing.zRot = 0.125f;
        this.wings.leftWing.yRot = -0.4f;
        this.wings.leftWing.zRot = -0.125f;
        if (entity.isCrouching()) {
            this.wings.rightWing.xRot = 0.45f;
            this.wings.rightWing.y = 3.33f;
            this.wings.rightWing.z = 3.388f;
            this.wings.leftWing.xRot = 0.45f;
            this.wings.leftWing.y = 3.33f;
            this.wings.leftWing.z = 3.388f;
        } else {
            this.wings.rightWing.xRot = 0.0f;
            this.wings.leftWing.xRot = 0.0f;
        }
        this.wings.rightWing.yRot -= Mth.sin((float)sinage) / 6.0f;
        this.wings.rightWing.zRot = this.wings.rightWing.zRot - Mth.cos((float)sinage) / (entity.onGround() || entity.isInFluidType() ? 8.0f : 3.0f);
        this.wings.leftWing.yRot += Mth.sin((float)sinage) / 6.0f;
        this.wings.leftWing.zRot = this.wings.leftWing.zRot + Mth.cos((float)sinage) / (entity.onGround() || entity.isInFluidType() ? 8.0f : 3.0f);
    }
}

