/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import reliquary.Reliquary;
import reliquary.init.ModItems;
import reliquary.util.StreamCodecHelper;

public record SpawnAngelheartVialParticlesPayload(Vec3 position) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpawnAngelheartVialParticlesPayload> TYPE = new CustomPacketPayload.Type(Reliquary.getRL("angelheart_vial_particles"));
    public static final StreamCodec<FriendlyByteBuf, SpawnAngelheartVialParticlesPayload> STREAM_CODEC = StreamCodec.composite(StreamCodecHelper.VEC_3_STREAM_CODEC, SpawnAngelheartVialParticlesPayload::position, SpawnAngelheartVialParticlesPayload::new);

    public static void handlePayload(SpawnAngelheartVialParticlesPayload payload) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        double x = payload.position.x;
        double y = payload.position.y;
        double z = payload.position.z;
        RandomSource random = player.level().random;
        ItemParticleOption itemParticleData = new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)ModItems.ANGELHEART_VIAL.get()));
        for (int i = 0; i < 8; ++i) {
            player.level().addParticle((ParticleOptions)itemParticleData, x, y, z, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
        }
        float red = 1.0f;
        float green = 0.0f;
        float blue = 1.0f;
        for (int i = 0; i < 100; ++i) {
            double distance = random.nextDouble() * 4.0;
            double angle = random.nextDouble() * Math.PI * 2.0;
            double xSpeed = Math.cos(angle) * distance;
            double ySpeed = 0.01 + random.nextDouble() * 0.5;
            double zSpeed = Math.sin(angle) * distance;
            Particle particle = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.EFFECT, x + xSpeed * 0.1, y + 0.3, z + zSpeed * 0.1, xSpeed, ySpeed, zSpeed);
            if (particle == null) continue;
            float colorMultiplier = 0.75f + random.nextFloat() * 0.25f;
            particle.setColor(red * colorMultiplier, green * colorMultiplier, blue * colorMultiplier);
            particle.setPower((float)distance);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

