/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import reliquary.common.gui.MobCharmBeltMenu;
import reliquary.item.ItemBase;
import reliquary.item.MobCharmItem;
import reliquary.item.util.ICuriosItem;
import reliquary.reference.Config;

public class MobCharmBeltItem
extends ItemBase
implements ICuriosItem {
    public MobCharmBeltItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public ICuriosItem.Type getCuriosType() {
        return ICuriosItem.Type.BELT;
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
    }

    @Override
    public void onEquipped(String identifier, LivingEntity player) {
        if (player.level().isClientSide) {
            player.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 1.0f, 1.0f);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> new MobCharmBeltMenu(w, p, stack), stack.getHoverName()), buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public ItemStack getMobCharmInSlot(ItemStack belt, int slotIndex) {
        return this.getFromHandler(belt, handler -> slotIndex < handler.getSlots() ? handler.getStackInSlot(slotIndex) : ItemStack.EMPTY);
    }

    public void putMobCharmInSlot(ItemStack belt, int slotIndex, ItemStack mobCharm) {
        if (mobCharm.isEmpty()) {
            this.removeMobCharmInSlot(belt, slotIndex);
            return;
        }
        this.runOnHandler(belt, handler -> {
            if (slotIndex >= handler.getSlots()) {
                handler.insertIntoNewSlot(mobCharm);
            } else {
                handler.setStackInSlot(slotIndex, mobCharm);
            }
        });
    }

    public ItemStack removeMobCharmInSlot(ItemStack belt, int slotIndex) {
        return this.getFromHandler(belt, handler -> slotIndex < handler.getSlots() ? handler.removeStackAndSlot(slotIndex) : ItemStack.EMPTY);
    }

    public int getCharmCount(ItemStack belt) {
        return this.getFromHandler(belt, ComponentItemHandler::getSlots);
    }

    public boolean hasCharm(ItemStack belt, ResourceLocation entityRegistryName) {
        return this.getFromHandler(belt, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack charmStack = handler.getStackInSlot(i);
                if (!MobCharmItem.isCharmFor(charmStack, entityRegistryName)) continue;
                return true;
            }
            return false;
        });
    }

    ItemStack damageCharm(Player player, ItemStack belt, ResourceLocation entityRegistryName) {
        return this.getFromHandler(belt, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack charmStack = handler.getStackInSlot(i);
                if (!MobCharmItem.isCharmFor(charmStack, entityRegistryName)) continue;
                charmStack.hurtAndBreak(((Integer)Config.COMMON.items.mobCharm.damagePerKill.get()).intValue(), (LivingEntity)player, EquipmentSlot.CHEST);
                if (charmStack.isEmpty()) {
                    handler.removeStackAndSlot(i);
                    return ItemStack.EMPTY;
                }
                handler.setStackInSlot(i, charmStack);
                return charmStack;
            }
            return ItemStack.EMPTY;
        });
    }

    public Set<ResourceLocation> getCharmRegistryNames(ItemStack slotStack) {
        return this.getFromHandler(slotStack, handler -> {
            HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack charmStack = handler.getStackInSlot(i);
                ret.add(MobCharmItem.getEntityEggRegistryName(charmStack));
            }
            return ret;
        });
    }

    private <T> T getFromHandler(ItemStack stack, Function<MobCharmComponentItemHandler, T> getter) {
        return getter.apply(new MobCharmComponentItemHandler((MutableDataComponentHolder)stack));
    }

    private void runOnHandler(ItemStack stack, Consumer<MobCharmComponentItemHandler> runner) {
        runner.accept(new MobCharmComponentItemHandler((MutableDataComponentHolder)stack));
    }

    private static class MobCharmComponentItemHandler
    extends ComponentItemHandler {
        public MobCharmComponentItemHandler(MutableDataComponentHolder parent) {
            super(parent, DataComponents.CONTAINER, MobCharmComponentItemHandler.getSlots(parent));
        }

        private static int getSlots(MutableDataComponentHolder parent) {
            return ((ItemContainerContents)parent.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).getSlots();
        }

        public void insertIntoNewSlot(ItemStack stack) {
            ItemContainerContents contents = this.getContents();
            NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlots(), this.getSlots() + 1), (Object)ItemStack.EMPTY);
            contents.copyInto(list);
            list.set(this.getSlots(), (Object)stack);
            this.parent.set(this.component, (Object)ItemContainerContents.fromItems((List)list));
            this.onContentsChanged(list.size() - 1, ItemStack.EMPTY, stack);
        }

        public ItemStack removeStackAndSlot(int slot) {
            int i;
            ItemContainerContents contents = this.getContents();
            NonNullList list = NonNullList.withSize((int)(this.getSlots() - 1), (Object)ItemStack.EMPTY);
            ItemStack stack = contents.getStackInSlot(slot);
            for (i = 0; i < slot; ++i) {
                list.set(i, (Object)(contents.getSlots() > i ? contents.getStackInSlot(i) : ItemStack.EMPTY));
            }
            for (i = slot; i < list.size(); ++i) {
                list.set(i, (Object)(contents.getSlots() > i + 1 ? contents.getStackInSlot(i + 1) : ItemStack.EMPTY));
            }
            this.parent.set(this.component, (Object)ItemContainerContents.fromItems((List)list));
            this.onContentsChanged(slot, stack, ItemStack.EMPTY);
            return stack;
        }
    }
}

