/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Queues;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.inventory.IInventoryCommonModifiable;
import org.cyclops.cyclopscore.inventory.IInventoryLocation;
import org.cyclops.cyclopscore.inventory.InventoryIterator;
import org.cyclops.cyclopscore.inventory.InventoryLocations;
import org.cyclops.cyclopscore.inventory.ItemLocation;

public class PlayerExtendedInventoryIterator
implements Iterator<ItemStack> {
    private final Queue<Pair<IInventoryLocation, InventoryIterator>> iterators = Queues.newArrayDeque();

    public PlayerExtendedInventoryIterator(Player player) {
        for (IInventoryLocation inventoryExtender : InventoryLocations.REGISTRY.values()) {
            IInventoryCommonModifiable inv = inventoryExtender.getInventory(player);
            if (inv == null) continue;
            this.iterators.add((Pair<IInventoryLocation, InventoryIterator>)Pair.of((Object)inventoryExtender, (Object)new InventoryIterator(inv)));
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterators.size() > 0 && ((InventoryIterator)this.iterators.peek().getRight()).hasNext();
    }

    @Override
    public ItemStack next() {
        if (((InventoryIterator)this.iterators.peek().getRight()).hasNext()) {
            Pair<IInventoryLocation, InventoryIterator> extendedAndIterator = this.iterators.peek();
            Pair<Integer, ItemStack> slotAndStack = ((InventoryIterator)extendedAndIterator.getRight()).nextIndexed();
            if (!((InventoryIterator)this.iterators.peek().getRight()).hasNext()) {
                this.iterators.poll();
            }
            return (ItemStack)slotAndStack.getRight();
        }
        throw new IndexOutOfBoundsException();
    }

    public ItemLocation nextIndexed() {
        if (((InventoryIterator)this.iterators.peek().getRight()).hasNext()) {
            Pair<IInventoryLocation, InventoryIterator> extendedAndIterator = this.iterators.peek();
            Pair<Integer, ItemStack> slotAndStack = ((InventoryIterator)extendedAndIterator.getRight()).nextIndexed();
            if (!((InventoryIterator)this.iterators.peek().getRight()).hasNext()) {
                this.iterators.poll();
            }
            return new ItemLocation((IInventoryLocation)extendedAndIterator.getLeft(), (Integer)slotAndStack.getLeft());
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented.");
    }

    public void replace(ItemStack itemStack) {
        ((InventoryIterator)this.iterators.peek().getRight()).replace(itemStack);
    }
}

