/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.SimpleInventoryCommon;

public class LargeInventoryCommon
extends SimpleInventoryCommon {
    public LargeInventoryCommon() {
        this(0, 0);
    }

    public LargeInventoryCommon(int size, int stackLimit) {
        super(size, stackLimit);
    }

    @Override
    public void readFromNBT(HolderLookup.Provider provider, CompoundTag data, String tag) {
        int j;
        ListTag nbttaglist = data.getList(tag, 10);
        for (j = 0; j < this.getContainerSize(); ++j) {
            this.contents[j] = ItemStack.EMPTY;
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            CompoundTag slot = nbttaglist.getCompound(j);
            int index = slot.contains("index") ? slot.getInt("index") : slot.getInt("Slot");
            if (index < 0 || index >= this.getContainerSize()) continue;
            this.contents[index] = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)slot);
        }
    }

    @Override
    public void writeToNBT(HolderLookup.Provider provider, CompoundTag data, String tag) {
        ListTag slots = new ListTag();
        for (int index = 0; index < this.getContainerSize(); ++index) {
            ItemStack itemStack = this.getItem(index);
            if (itemStack.isEmpty() || itemStack.getCount() <= 0) continue;
            CompoundTag slot = new CompoundTag();
            slot.putInt("Slot", index);
            slots.add((Object)itemStack.save(provider, (Tag)slot));
        }
        data.put(tag, (Tag)slots);
    }
}

