/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntityCommon;
import org.cyclops.cyclopscore.helper.IModHelpers;

public abstract class BlockWithEntityCommon
extends BaseEntityBlock {
    private final BiFunction<BlockPos, BlockState, ? extends CyclopsBlockEntityCommon> blockEntitySupplier;

    public BlockWithEntityCommon(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, ? extends CyclopsBlockEntityCommon> blockEntitySupplier) {
        super(properties);
        this.blockEntitySupplier = blockEntitySupplier;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.blockEntitySupplier.apply(blockPos, blockState);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState playerWillDestroy(Level world, BlockPos blockPos, BlockState blockState, Player player) {
        return super.playerWillDestroy(world, blockPos, blockState, player);
    }

    protected ItemStack getDroppedItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos blockPos, Player player, ItemStack originalItemStack) {
        return originalItemStack;
    }

    protected CompoundTag getDroppedItemStackNbt(BlockState state, HitResult target, BlockGetter world, BlockPos blockPos, Player player, ItemStack itemStack, CyclopsBlockEntityCommon blockEntity) {
        return blockEntity.writeToItemStack(new CompoundTag(), (HolderLookup.Provider)player.level().registryAccess());
    }

    public boolean isPersistNbt() {
        return false;
    }

    public static ItemStack getCloneItemStack(BlockWithEntityCommon self, Supplier<ItemStack> superMethod, BlockState state, HitResult target, LevelReader world, BlockPos blockPos, Player player) {
        ItemStack itemStack = self.getDroppedItemStack(state, target, (BlockGetter)world, blockPos, player, superMethod.get());
        if (self.isPersistNbt()) {
            IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, blockPos, CyclopsBlockEntityCommon.class).ifPresent(blockEntity -> {
                CompoundTag compoundnbt = self.getDroppedItemStackNbt(state, target, (BlockGetter)world, blockPos, player, itemStack, (CyclopsBlockEntityCommon)blockEntity);
                if (!compoundnbt.isEmpty()) {
                    itemStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)compoundnbt));
                }
            });
        }
        return itemStack;
    }
}

