/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.gen;

import mcjty.lostcities.api.ILostWorldsChunkGenerator;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.ChunkFixer;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.gen.Monorails;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class Spheres {
    public static void generateSpheres(LostCityTerrainFeature feature, WorldGenRegion region, ChunkAccess chunk) {
        IDimensionInfo provider = feature.provider;
        LostCityProfile profile = feature.profile;
        ChunkDriver driver = feature.driver;
        if (profile.isSpace() || profile.isSpheres()) {
            LevelAccessor oldRegion = driver.getRegion();
            ChunkAccess oldChunk = driver.getPrimer();
            driver.setPrimer((LevelAccessor)region, chunk);
            int chunkX = chunk.getPos().x;
            int chunkZ = chunk.getPos().z;
            ChunkCoord coord = new ChunkCoord(provider.getType(), chunkX, chunkZ);
            CitySphere sphere = CitySphere.getCitySphere(coord, provider);
            CitySphere.initSphere(sphere, provider);
            if (sphere.isEnabled()) {
                float radius = sphere.getRadius();
                BlockPos cc = sphere.getCenterPos();
                int cx = cc.getX() - (chunkX << 4);
                int cz = cc.getZ() - (chunkZ << 4);
                Spheres.fillSphere(feature, cx, profile.GROUNDLEVEL, cz, (int)radius, sphere.getGlassBlock(), sphere.getSideBlock());
            }
            if (profile.isSpace()) {
                BuildingInfo info = BuildingInfo.getBuildingInfo(coord, provider);
                Monorails.generateMonorails(feature, info);
            }
            driver.actuallyGenerate(chunk);
            driver.setPrimer(oldRegion, oldChunk);
            ChunkFixer.fix(provider, coord);
        }
    }

    private static void fillSphere(LostCityTerrainFeature feature, int centerx, int centery, int centerz, int radius, BlockState glass, BlockState sideBlock) {
        ILostWorldsChunkGenerator lw;
        Integer o;
        ChunkGenerator generator;
        IDimensionInfo provider = feature.provider;
        ChunkDriver driver = feature.driver;
        LostCityProfile profile = feature.profile;
        BlockState air = Blocks.AIR.defaultBlockState();
        double sqradius = radius * radius;
        double sqradiusOffset = (radius - 2) * (radius - 2);
        double sqradiusOuter = (radius + 2) * (radius + 2);
        int minY = Math.max(provider.getWorld().getMinBuildHeight(), centery - radius - 1);
        int maxY = Math.min(provider.getWorld().getMaxBuildHeight(), centery + radius + 1);
        int seaLevel = Tools.getSeaLevel((LevelReader)provider.getWorld());
        WorldGenLevel worldGenLevel = provider.getWorld();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)worldGenLevel;
            generator = ((ServerChunkCache)region.getChunkSource()).getGenerator();
        } else {
            generator = ((ServerLevel)provider.getWorld()).getChunkSource().getGenerator();
        }
        int outerSeaLevel = -1000;
        if (generator instanceof ILostWorldsChunkGenerator && (o = (lw = (ILostWorldsChunkGenerator)generator).getOuterSeaLevel()) != null) {
            outerSeaLevel = o;
        }
        for (int x = 0; x < 16; ++x) {
            double dxdx = (x - centerx) * (x - centerx);
            block1: for (int z = 0; z < 16; ++z) {
                int y;
                double dzdz = (z - centerz) * (z - centerz);
                int bottom = Integer.MAX_VALUE;
                if (dxdx + dzdz <= sqradius) {
                    double sqdist;
                    double dydy;
                    driver.current(x, minY, z);
                    for (y = minY; y <= centery; ++y) {
                        dydy = (y - centery) * (y - centery);
                        sqdist = dxdx + dydy + dzdz;
                        if (sqdist <= sqradius && sqdist >= sqradiusOffset) {
                            if (y < bottom) {
                                bottom = y - 1;
                            }
                            driver.block(sideBlock);
                        }
                        driver.incY();
                    }
                    for (y = centery + 1; y < maxY; ++y) {
                        dydy = (y - centery) * (y - centery);
                        sqdist = dxdx + dydy + dzdz;
                        if (sqdist <= sqradius) {
                            if (sqdist >= sqradiusOffset) {
                                driver.block(glass);
                            }
                        } else {
                            int yy;
                            int mY;
                            if (profile.CITYSPHERE_CLEARABOVE > 0) {
                                mY = Math.min(provider.getWorld().getMaxBuildHeight(), y + profile.CITYSPHERE_CLEARABOVE);
                                for (yy = y; yy <= mY; ++yy) {
                                    driver.block(yy <= outerSeaLevel ? feature.liquid : air);
                                    driver.incY();
                                }
                            }
                            if (profile.CITYSPHERE_CLEARABOVE_UNTIL_AIR) {
                                while (driver.getBlock() != air) {
                                    driver.block(yy <= outerSeaLevel ? feature.liquid : air);
                                    driver.incY();
                                    ++yy;
                                }
                            }
                            if (profile.CITYSPHERE_CLEARBELOW > 0 && bottom != Integer.MAX_VALUE) {
                                driver.current(x, yy, z);
                                mY = Math.max(provider.getWorld().getMinBuildHeight(), bottom - profile.CITYSPHERE_CLEARBELOW);
                                for (yy = bottom; yy >= mY; --yy) {
                                    driver.block(yy <= outerSeaLevel ? feature.liquid : air);
                                    driver.decY();
                                }
                            }
                            if (!profile.CITYSPHERE_CLEARBELOW_UNTIL_AIR || bottom == Integer.MAX_VALUE) continue block1;
                            driver.current(x, yy, z);
                            while (driver.getBlock() != (yy <= seaLevel ? feature.liquid : air) && yy > provider.getWorld().getMinBuildHeight()) {
                                driver.block(yy <= outerSeaLevel ? feature.liquid : air);
                                driver.decY();
                                --yy;
                            }
                            continue block1;
                        }
                        driver.incY();
                    }
                    continue;
                }
                if (!(dxdx + dzdz <= sqradiusOuter) || !profile.isFloating() && !profile.isSpace()) continue;
                driver.current(x, minY, z);
                for (y = minY; y < maxY; ++y) {
                    driver.block(y <= outerSeaLevel ? feature.liquid : air);
                    driver.incY();
                }
            }
        }
    }
}

