/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.config.ProfileSetup;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.ForgeEventHandlers;
import mcjty.lostcities.worldgen.DefaultDimensionInfo;
import mcjty.lostcities.worldgen.ErrorLogger;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.neoforged.neoforge.common.Tags;

public class LostCityFeature
extends Feature<NoneFeatureConfiguration> {
    private final Map<ResourceKey<Level>, IDimensionInfo> dimensionInfo = new HashMap<ResourceKey<Level>, IDimensionInfo>();
    public static int globalDimensionInfoDirtyCounter = 0;
    private int dimensionInfoDirtyCounter = -1;
    private static final long[] times = new long[1000];
    private static long totalCnt = 0L;

    public LostCityFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        IDimensionInfo diminfo;
        WorldGenLevel level = context.level();
        if (level instanceof WorldGenRegion && (diminfo = this.getDimensionInfo(level)) != null) {
            WorldGenRegion region = (WorldGenRegion)level;
            ChunkPos center = region.getCenter();
            Holder biome = region.getBiome(center.getMiddleBlockPosition(60));
            if (biome.is(Tags.Biomes.IS_VOID)) {
                return false;
            }
            int chunkX = center.x;
            int chunkZ = center.z;
            diminfo.setWorld(level);
            try {
                diminfo.getFeature().generate(region, region.getChunk(chunkX, chunkZ));
            }
            catch (Exception e) {
                LostCities.getLogger().error("Error generating chunk {},{}: {}", (Object)chunkX, (Object)chunkZ, (Object)e.getMessage(), (Object)e);
                e.printStackTrace();
                ErrorLogger.logChunkInfo(chunkX, chunkZ, diminfo);
                ErrorLogger.report("There was an error generating a chunk. See log for details!");
            }
            return true;
        }
        return false;
    }

    @Nullable
    public IDimensionInfo getDimensionInfo(WorldGenLevel world) {
        if (globalDimensionInfoDirtyCounter != this.dimensionInfoDirtyCounter) {
            this.cleanUp();
        }
        ResourceKey type = world.getLevel().dimension();
        String profileName = Config.getProfileForDimension(world.getLevel(), (ResourceKey<Level>)type);
        if (profileName != null) {
            if (!this.dimensionInfo.containsKey(type)) {
                LostCityProfile profile = ProfileSetup.STANDARD_PROFILES.get(profileName);
                if (profile == null) {
                    return null;
                }
                LostCityProfile outsideProfile = profile.CITYSPHERE_OUTSIDE_PROFILE == null ? null : ProfileSetup.STANDARD_PROFILES.get(profile.CITYSPHERE_OUTSIDE_PROFILE);
                DefaultDimensionInfo diminfo = new DefaultDimensionInfo(world, profile, outsideProfile);
                this.dimensionInfo.put((ResourceKey<Level>)type, diminfo);
            }
            return this.dimensionInfo.get(type);
        }
        return null;
    }

    public void cleanUp() {
        LostCities.lostCitiesImp.cleanUp();
        ForgeEventHandlers.cleanUp();
        AssetRegistries.reset();
        this.dimensionInfo.clear();
        this.dimensionInfoDirtyCounter = globalDimensionInfoDirtyCounter;
    }
}

