/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.data;

import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class LostData
extends SavedData {
    public static final String NAME = "lostcities_data";
    private String selectedProfile = "";
    private String selectedJson = "";

    @Nonnull
    public static LostData getData(Level level) {
        if (level.isClientSide) {
            throw new RuntimeException("Don't access this client-side!");
        }
        MinecraftServer server = level.getServer();
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (LostData)storage.computeIfAbsent(new SavedData.Factory(LostData::new, LostData::new), NAME);
    }

    public LostData() {
    }

    public LostData(CompoundTag tag, HolderLookup.Provider provider) {
        this.selectedProfile = tag.getString("profile");
        this.selectedJson = tag.getString("json");
    }

    public void setProfile(String profile, String json) {
        this.selectedProfile = profile;
        this.selectedJson = json;
        this.setDirty();
    }

    public String getSelectedProfile() {
        return this.selectedProfile;
    }

    public String getSelectedJson() {
        return this.selectedJson;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putString("profile", this.selectedProfile);
        tag.putString("json", this.selectedJson);
        return tag;
    }
}

