/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.iface.ICustomBow;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class BaseBowItem
extends BowItem
implements ICustomBow {
    public BaseBowItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.apply(new Item.Properties()));
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack itemstack = player.getProjectile(stack);
            int i = (int)((float)(this.getUseDuration(stack, entity) - timeLeft) * this.getDrawSpeedMulti(stack));
            if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
                return;
            }
            float f = BaseBowItem.getPowerForTime((int)i);
            if (!((double)f < 0.1)) {
                List list = BaseBowItem.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    if (!list.isEmpty()) {
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * 3.0f, 1.0f, f == 1.0f, null);
                    }
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        arrow.setBaseDamage(arrow.getBaseDamage() + (double)this.getBonusDamage(weaponStack));
        return arrow;
    }

    @Override
    public boolean hasFOVChange() {
        return true;
    }

    public static ItemPropertyFunction getPullPropertyGetter() {
        return (stack, level, entity, _unused) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) * ((ICustomBow)stack.getItem()).getDrawSpeedMulti(stack) / 20.0f;
        };
    }

    public static ItemPropertyFunction getPullingPropertyGetter() {
        return (stack, level, entity, _unused) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f;
    }
}

