/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public final class BlockHelper {
    public static BlockHitResult rayTraceBlocks(Level level, Player player) {
        return BlockHelper.rayTraceBlocks(level, player, ClipContext.Fluid.NONE);
    }

    public static BlockHitResult rayTraceBlocks(Level level, Player player, ClipContext.Fluid fluidMode) {
        AttributeInstance attribute = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        double reach = attribute != null ? attribute.getValue() : 4.5;
        return BlockHelper.rayTraceBlocks(level, player, reach, fluidMode);
    }

    private static BlockHitResult rayTraceBlocks(Level level, Player player, double reach, ClipContext.Fluid fluidMode) {
        float pitch = player.getXRot();
        float yaw = player.getYRot();
        Vec3 eyePos = player.getEyePosition(1.0f);
        float f2 = Mth.cos((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vec3d1 = eyePos.add((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return level.clip(new ClipContext(eyePos, vec3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    public static boolean harvestBlock(ItemStack stack, Level level, ServerPlayer player, BlockPos pos) {
        return BlockHelper.harvestBlock(stack, level, player, pos, true);
    }

    public static boolean harvestBlock(ItemStack stack, Level level, ServerPlayer player, BlockPos pos, boolean playEvent) {
        BlockState state;
        if (level.isClientSide()) {
            return true;
        }
        GameType type = player.gameMode.getGameModeForPlayer();
        BlockEvent.BreakEvent event = CommonHooks.fireBlockBreak((Level)level, (GameType)type, (ServerPlayer)player, (BlockPos)pos, (BlockState)(state = level.getBlockState(pos)));
        if (event.isCanceled()) {
            return false;
        }
        if (player.blockActionRestricted(level, pos, type)) {
            return false;
        }
        if (playEvent) {
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        boolean destroyed = BlockHelper.destroyBlock(state, level, (Player)player, pos);
        if (player.isCreative()) {
            return true;
        }
        Block block = state.getBlock();
        if (destroyed && state.canHarvestBlock((BlockGetter)level, pos, (Player)player)) {
            block.playerDestroy(level, (Player)player, pos, state, level.getBlockEntity(pos), stack);
            stack.mineBlock(level, state, pos, (Player)player);
        }
        BlockEntity tile = level.getBlockEntity(pos);
        int exp = state.getExpDrop((LevelAccessor)level, pos, tile, (Entity)player, stack);
        if (destroyed && exp > 0) {
            block.popExperience(player.serverLevel(), pos, exp);
        }
        return true;
    }

    public static boolean harvestAOEBlock(ItemStack stack, Level level, ServerPlayer player, BlockPos pos) {
        if (BlockHelper.harvestBlock(stack, level, player, pos, false)) {
            player.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            return true;
        }
        return false;
    }

    public static boolean destroyBlock(BlockState state, Level level, Player player, BlockPos pos) {
        boolean canHarvest = !player.isCreative() && state.canHarvestBlock((BlockGetter)level, pos, player);
        boolean destroyed = state.onDestroyedByPlayer(level, pos, player, canHarvest, level.getFluidState(pos));
        if (destroyed) {
            state.getBlock().destroy((LevelAccessor)level, pos, state);
        }
        return destroyed;
    }

    public static int getRedstoneSignalFromInventory(@Nullable BlockEntity entity) {
        if (entity instanceof BaseInventoryTileEntity) {
            BaseInventoryTileEntity tile = (BaseInventoryTileEntity)entity;
            BaseItemStackHandler inventory = tile.getInventory();
            float f = 0.0f;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                f += (float)stack.getCount() / (float)inventory.getStackLimit(i, stack);
            }
            return Mth.lerpDiscrete((float)(f /= (float)inventory.getSlots()), (int)0, (int)15);
        }
        return 0;
    }
}

