/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.IDraconicMelee;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DEDamage {
    private static Map<ResourceKey<DamageType>, DamageSource> SOURCES = new HashMap<ResourceKey<DamageType>, DamageSource>();
    public static ResourceKey<DamageType> FUSION_EXPLOSION = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"fusion_explosion"));
    public static ResourceKey<DamageType> KILL = DamageTypes.GENERIC_KILL;
    public static ResourceKey<DamageType> CRYSTAL_MOVE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"crystal_move"));
    public static ResourceKey<DamageType> CHAOS_IMPLOSION = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"chaos_implosion"));
    public static ResourceKey<DamageType> GUARDIAN = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"guardian"));
    public static ResourceKey<DamageType> GUARDIAN_PROJECTILE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"guardian_projectile"));
    public static ResourceKey<DamageType> GUARDIAN_LASER = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"guardian_laser"));
    public static ResourceKey<DamageType> DRACONIUM_ARROW = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"draconium_arrow"));
    public static ResourceKey<DamageType> DRACONIUM_ARROW_SPOOF = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"draconium_arrow_spoof"));
    public static ResourceKey<DamageType> WYVERN_ARROW = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"wyvern_arrow"));
    public static ResourceKey<DamageType> WYVERN_ARROW_SPOOF = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"wyvern_arrow_spoof"));
    public static ResourceKey<DamageType> DRACONIC_ARROW = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"draconic_arrow"));
    public static ResourceKey<DamageType> DRACONIC_ARROW_SPOOF = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"draconic_arrow_spoof"));
    public static ResourceKey<DamageType> CHAOTIC_ARROW = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"chaotic_arrow"));
    public static ResourceKey<DamageType> CHAOTIC_ARROW_SPOOF = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"chaotic_arrow_spoof"));

    public static DamageSource fusionDamage(Level level) {
        return DEDamage.getSource(level, FUSION_EXPLOSION);
    }

    public static DamageSource killDamage(Level level) {
        return DEDamage.getSource(level, (ResourceKey<DamageType>)DamageTypes.GENERIC_KILL);
    }

    public static DamageSource crystalMove(Level level) {
        return DEDamage.getSource(level, CRYSTAL_MOVE);
    }

    public static DamageSource chaosImplosion(Level level) {
        return DEDamage.getSource(level, CHAOS_IMPLOSION);
    }

    public static DamageSource guardianProjectile(Level level, @Nullable Entity projectile, @Nullable Entity owner) {
        return DEDamage.getSource(level, GUARDIAN_PROJECTILE, projectile, owner);
    }

    public static DamageSource guardianLaser(Level level, @Nullable Entity attacker) {
        return DEDamage.getSource(level, GUARDIAN_LASER, attacker);
    }

    public static DamageSource guardian(Level level, @Nullable Entity attacker) {
        return DEDamage.getSource(level, GUARDIAN, attacker);
    }

    public static DamageSource draconicArrow(Level level, @Nullable Entity projectile, @Nullable Entity owner, TechLevel techLevel, boolean bypassImmune) {
        ResourceKey<DamageType> key = switch (techLevel) {
            default -> throw new MatchException(null, null);
            case TechLevel.DRACONIUM -> {
                if (bypassImmune) {
                    yield DRACONIUM_ARROW_SPOOF;
                }
                yield DRACONIUM_ARROW;
            }
            case TechLevel.WYVERN -> {
                if (bypassImmune) {
                    yield WYVERN_ARROW_SPOOF;
                }
                yield WYVERN_ARROW;
            }
            case TechLevel.DRACONIC -> {
                if (bypassImmune) {
                    yield DRACONIC_ARROW_SPOOF;
                }
                yield DRACONIC_ARROW;
            }
            case TechLevel.CHAOTIC -> bypassImmune ? CHAOTIC_ARROW_SPOOF : CHAOTIC_ARROW;
        };
        return DEDamage.getSource(level, key, bypassImmune ? null : projectile, owner);
    }

    private static DamageSource getSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker) {
        return new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(type), attacker);
    }

    private static DamageSource getSource(Level level, ResourceKey<DamageType> type, @Nullable Entity projectile, @Nullable Entity owner) {
        return new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(type), projectile, owner);
    }

    private static DamageSource getSource(Level level, ResourceKey<DamageType> type) {
        return SOURCES.computeIfAbsent(type, e -> new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(e)));
    }

    @Nullable
    public static TechLevel getDamageLevel(DamageSource source) {
        Player player;
        ItemStack stack;
        Item item;
        if (source.is(Tags.CHAOTIC)) {
            return TechLevel.CHAOTIC;
        }
        if (source.is(Tags.DRACONIC)) {
            return TechLevel.DRACONIC;
        }
        if (source.is(Tags.WYVERN)) {
            return TechLevel.WYVERN;
        }
        if (source.is(Tags.DRACONIUM)) {
            return TechLevel.DRACONIUM;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player && (item = (stack = (player = (Player)entity).getMainHandItem()).getItem()) instanceof IDraconicMelee) {
            IDraconicMelee melee = (IDraconicMelee)item;
            return melee.getTechLevel();
        }
        return null;
    }

    public static class Tags {
        public static final TagKey<DamageType> CHAOTIC = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"chaotic"));
        public static final TagKey<DamageType> DRACONIC = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"draconic"));
        public static final TagKey<DamageType> WYVERN = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"wyvern"));
        public static final TagKey<DamageType> DRACONIUM = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"draconium"));
        public static final TagKey<DamageType> PROJECTILE_ANTI_DODGE = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"proj_anti_dodge"));
    }
}

