/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.api.DislocatorEndPoint;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class TileTarget
extends DislocatorTarget {
    private BlockPos tilePos;

    public TileTarget(DislocatorEndPoint endPoint) {
        super((ResourceKey<Level>)((BlockEntity)endPoint).getLevel().dimension());
        this.tilePos = ((BlockEntity)endPoint).getBlockPos();
    }

    public TileTarget(ResourceKey<Level> world) {
        super(world);
    }

    private DislocatorEndPoint getEndPoint(ServerLevel world) {
        BlockEntity tile = world.getBlockEntity(this.tilePos);
        if (tile instanceof DislocatorEndPoint) {
            return (DislocatorEndPoint)tile;
        }
        return null;
    }

    @Override
    public TargetPos getTargetPos(MinecraftServer server, UUID linkID, UUID sourceDislocatorID) {
        Vec3 pos;
        ServerLevel targetWorld = this.getTargetWorld(server);
        DislocatorEndPoint target = this.getEndPoint(targetWorld);
        if (target != null && (pos = target.getArrivalPos(linkID)) != null) {
            Vec2 vec = target.getArrivalFacing(linkID);
            if (vec != null) {
                return TargetPos.of((Vector3)new Vector3(pos), (ResourceKey)this.worldKey, (Vec2)vec);
            }
            return TargetPos.of((Vector3)new Vector3(pos), (ResourceKey)this.worldKey);
        }
        return null;
    }

    @Override
    public void preTeleport(MinecraftServer server, Entity entity) {
        ServerLevel targetWorld = this.getTargetWorld(server);
        DislocatorEndPoint target = this.getEndPoint(targetWorld);
        if (target != null) {
            target.entityArriving(entity);
        }
    }

    public BlockPos getTilePos() {
        return this.tilePos;
    }

    @Override
    public CompoundTag save(CompoundTag nbt) {
        nbt.putInt("x", this.tilePos.getX());
        nbt.putInt("y", this.tilePos.getY());
        nbt.putInt("z", this.tilePos.getZ());
        return super.save(nbt);
    }

    @Override
    protected void loadInternal(CompoundTag nbt) {
        super.loadInternal(nbt);
        this.tilePos = new BlockPos(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z"));
    }

    @Override
    public DislocatorTarget.TargetType getType() {
        return DislocatorTarget.TargetType.TILE;
    }
}

