/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.blocks.tileentity.TileEntityDetector;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class RenderTileEntityDetector
implements BlockEntityRenderer<TileEntityDetector> {
    private ItemStack eye = ItemStack.EMPTY;
    private ItemStack skull = ItemStack.EMPTY;

    public RenderTileEntityDetector(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityDetector te, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedoverlay) {
        Minecraft mc = Minecraft.getInstance();
        boolean advanced = te.isAdvanced();
        float scale = advanced ? 0.5f : 0.35f;
        float yaw = te.lastLookYaw + (te.lookYaw - te.lastLookYaw) * partialTicks;
        float pitch = te.lastLookPitch + (te.lookPitch - te.lastLookPitch) * partialTicks;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.73, 0.5);
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        mc.getItemRenderer().renderStatic(this.getRenderStack(advanced), ItemDisplayContext.FIXED, packedLight, packedLight, poseStack, buffers, te.getLevel(), te.posSeed());
        poseStack.popPose();
    }

    private ItemStack getRenderStack(boolean advanced) {
        if (advanced) {
            if (this.skull.isEmpty()) {
                this.skull = new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL, 1);
            }
            return this.skull;
        }
        if (this.eye.isEmpty()) {
            this.eye = new ItemStack((ItemLike)Items.ENDER_EYE);
        }
        return this.eye;
    }

    public AABB getRenderBoundingBox(TileEntityDetector blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).expandTowards(0.0, 1.0, 0.0);
    }
}

