/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyTransfuser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class RenderTileEnergyTransfuser
implements BlockEntityRenderer<TileEnergyTransfuser> {
    private static final Style GALACTIC_STYLE = Style.EMPTY.withFont(Minecraft.ALT_FONT);
    public static final Component[] TEXT = new Component[]{Component.literal((String)"N").withStyle(GALACTIC_STYLE), Component.literal((String)"E").withStyle(GALACTIC_STYLE), Component.literal((String)"S").withStyle(GALACTIC_STYLE), Component.literal((String)"W").withStyle(GALACTIC_STYLE)};
    private static final Direction[] DIR_MAP = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public RenderTileEnergyTransfuser(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEnergyTransfuser tile, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        mStack.translate(0.5, 0.5, 0.5);
        for (int i = 0; i < 4; ++i) {
            Direction dir = DIR_MAP[i];
            mStack.pushPose();
            mStack.translate(0.5 * (double)dir.getStepX(), 0.0, 0.5 * (double)dir.getStepZ());
            mStack.mulPose(dir.getRotation());
            mStack.pushPose();
            mStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            double xOffset = dir == Direction.NORTH ? 2.0 : (dir == Direction.SOUTH ? 1.0 : 2.5);
            mStack.translate(0.0625 * -xOffset, -0.21875, 0.0859375);
            mStack.scale(0.0625f, 0.0625f, 0.0625f);
            mc.font.drawInBatch(TEXT[i].getVisualOrderText(), 0.0f, 0.0f, ((TileEnergyTransfuser.ItemIOMode)tile.ioModes[i].get()).getColour(), false, mStack.last().pose(), getter, Font.DisplayMode.NORMAL, 240, 240);
            mStack.popPose();
            ItemStack stack = tile.itemsCombined.getStackInSlot(i);
            if (!stack.isEmpty()) {
                mStack.mulPose(new Quaternionf().rotationYXZ(1.5707964f, 1.5707964f, (float)Math.PI));
                mStack.translate(0.0, 0.0, 0.046875);
                mStack.scale(0.5f, 0.5f, 0.5f);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, mStack, getter, tile.getLevel(), tile.posSeed());
            }
            mStack.popPose();
        }
    }
}

