/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlinkParticle
extends TextureSheetParticle {
    private BlinkParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.x = x;
        this.y = y;
        this.z = z;
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.2f + 0.5f) * 1.5f;
        float f = this.random.nextFloat() * 0.6f + 0.4f;
        this.rCol = f * 0.9f;
        this.gCol = f * 0.3f;
        this.bCol = f;
        this.lifetime = (int)(Math.random() * 2.0) + 30;
    }

    public float getQuadSize(float scaleFactor) {
        float f = 1.0f - ((float)this.age + scaleFactor) / ((float)this.lifetime * 1.5f);
        return this.quadSize * f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.x += this.xd;
            this.y += this.yd;
            this.z += this.zd;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BlinkParticle reverseportalparticle = new BlinkParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            reverseportalparticle.pickSprite(this.spriteSet);
            return reverseportalparticle;
        }
    }
}

