/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.ReactorBeamFX;
import com.brandon3055.draconicevolution.client.sound.ReactorSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@Deprecated
public class ReactorEffectHandler {
    private TileReactorCore reactor;
    @OnlyIn(value=Dist.CLIENT)
    private ReactorBeamFX[] effects;
    @OnlyIn(value=Dist.CLIENT)
    private ReactorSound reactorSound;

    public ReactorEffectHandler(TileReactorCore reactor) {
        this.reactor = reactor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateEffects() {
        if (this.effects == null) {
            this.effects = new ReactorBeamFX[6];
        }
        if ((this.reactorSound == null || this.reactorSound.isStopped() || !Minecraft.getInstance().getSoundManager().isActive((SoundInstance)this.reactorSound)) && ((TileReactorCore.ReactorState)this.reactor.reactorState.get()).isShieldActive() && this.reactor.shieldCharge.get() > 0.0) {
            this.reactorSound = new ReactorSound(this.reactor);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.reactorSound);
        } else if (this.reactorSound != null && (!((TileReactorCore.ReactorState)this.reactor.reactorState.get()).isShieldActive() || this.reactor.shieldCharge.get() <= 0.0)) {
            this.reactorSound.donePlaying = true;
        }
        if (this.reactor.reactorState.get() == TileReactorCore.ReactorState.INVALID || this.reactor.shieldAnimationState <= 0.0f) {
            return;
        }
        for (Direction facing : Direction.values()) {
            ReactorBeamFX beamFX;
            int index = facing.get3DDataValue();
            TileReactorComponent component = this.reactor.getComponent(facing);
            if (component == null) {
                if (this.effects[index] == null) continue;
                this.effects[index].remove();
                this.effects[index] = null;
                continue;
            }
            if (this.effects[index] != null && this.effects[index].isAlive()) {
                this.effects[index].updateFX(this.reactor.shieldAnimationState, 1.0f);
                continue;
            }
            this.effects[index] = beamFX = new ReactorBeamFX((ClientLevel)this.reactor.getLevel(), Vec3D.getCenter((BlockPos)component.getBlockPos()), (Direction)component.facing.get(), this.reactor, component instanceof TileReactorInjector);
            DEParticles.addParticleDirect(this.reactor.getLevel(), beamFX);
        }
    }
}

