/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.various.blocks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SafeClientTools;
import mcjty.xnet.modules.various.blocks.RedstoneProxyBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RedstoneProxyUBlock
extends RedstoneProxyBlock
implements ITooltipSettings {
    private final Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        if (SafeClientTools.isSneaking()) {
            tooltip.add((Component)ComponentFactory.translatable((String)"message.xnet.redstone_proxy_upd.header").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)ComponentFactory.translatable((String)"message.xnet.redstone_proxy_upd.gold").withStyle(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)ComponentFactory.translatable((String)"message.xnet.shiftmessage"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void neighborChanged(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (this.loopDetector.add(pos)) {
            try {
                worldIn.updateNeighborsAt(pos, (Block)this);
            }
            finally {
                this.loopDetector.remove(pos);
            }
        }
    }
}

