/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStat;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public record StatModifier<T>(SpawnerStat<T> stat, T value, Optional<T> min, Optional<T> max, Mode mode) {
    private static final Map<SpawnerStat<?>, MapCodec<StatModifier<?>>> CODEC_CACHE = new ConcurrentHashMap();
    public static final Codec<StatModifier<?>> CODEC = Codec.lazyInitialized(() -> SpawnerStats.REGISTRY.byNameCodec().dispatch(StatModifier::stat, StatModifier::modifierCodec));

    public StatModifier(SpawnerStat<T> stat, T value) {
        this(stat, value, Optional.empty(), Optional.empty(), Mode.ADD);
    }

    public boolean apply(ApothSpawnerTile tile) {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.stat.applyModifier(tile, this.value, this.min, this.max);
            case 1 -> {
                if (this.stat.getValue(tile) == this.value) {
                    yield false;
                }
                this.stat.setValue(tile, this.value);
                yield true;
            }
        };
    }

    public String getFormattedValue() {
        return this.stat.formatValue(this.value);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.stat.getId());
        buf.writeNbt((Tag)StatModifier.modifierCodec(this.stat).codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow());
    }

    public static StatModifier<?> read(FriendlyByteBuf buf) {
        SpawnerStat stat = (SpawnerStat)SpawnerStats.REGISTRY.get(buf.readResourceLocation());
        return (StatModifier)((Pair)StatModifier.modifierCodec(stat).codec().decode((DynamicOps)NbtOps.INSTANCE, (Object)buf.readNbt()).getOrThrow()).getFirst();
    }

    public static <T> MapCodec<StatModifier<T>> modifierCodec(SpawnerStat<T> stat) {
        return CODEC_CACHE.computeIfAbsent(stat, s -> StatModifier.createModifierCodec(s));
    }

    private static <T> MapCodec<StatModifier<T>> createModifierCodec(SpawnerStat<T> stat) {
        return RecordCodecBuilder.mapCodec(inst -> inst.group((App)stat.getValueCodec().fieldOf("value").forGetter(StatModifier::value), (App)stat.getValueCodec().optionalFieldOf("min").forGetter(StatModifier::min), (App)stat.getValueCodec().optionalFieldOf("max").forGetter(StatModifier::max), (App)Mode.CODEC.optionalFieldOf("mode", (Object)Mode.ADD).forGetter(StatModifier::mode)).apply((Applicative)inst, (value, min, max, mode) -> new StatModifier<Object>(stat, value, (Optional<Object>)min, (Optional<Object>)max, (Mode)((Object)((Object)mode)))));
    }

    public static enum Mode implements StringRepresentable
    {
        ADD("add"),
        SET("set");

        public static final IntFunction<Mode> BY_ID;
        public static final Codec<Mode> CODEC;
        public static final StreamCodec<ByteBuf, Mode> STREAM_CODEC;
        private String name;

        private Mode(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Mode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromValues(Mode::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

