/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class InvConfig {
    public static InvConfig CONFIG;
    public ModConfigSpec clientSpec;
    private final Client client;

    public static void register(ModContainer context) {
        CONFIG = new InvConfig();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)InvConfig.CONFIG.clientSpec);
    }

    private InvConfig() {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        this.clientSpec = (ModConfigSpec)specPair.getRight();
        this.client = (Client)specPair.getLeft();
    }

    public Client getClient() {
        return this.client;
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue byDefault;
        public final ModConfigSpec.BooleanValue ArmorDamage;
        public final ModConfigSpec.BooleanValue Potions;
        public final ModConfigSpec.BooleanValue invMini;
        public final ModConfigSpec.BooleanValue invVert;
        public final ModConfigSpec.BooleanValue invWithDebug;
        public final ModConfigSpec.BooleanValue animatedInv;
        public final ModConfigSpec.BooleanValue hideBackground;
        public final ModConfigSpec.BooleanValue keepNotifying;
        public final ModConfigSpec.IntValue xPos;
        public final ModConfigSpec.IntValue yPos;
        public final ModConfigSpec.IntValue invAlpha;
        public final ModConfigSpec.ConfigValue<String> lastNotifiedVersion;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> invValign;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> invHalign;
        public final ModConfigSpec.IntValue helmPosX;
        public final ModConfigSpec.IntValue helmPosY;
        public final ModConfigSpec.IntValue chestPosX;
        public final ModConfigSpec.IntValue chestPosY;
        public final ModConfigSpec.IntValue legPosX;
        public final ModConfigSpec.IntValue legPosY;
        public final ModConfigSpec.IntValue bootPosX;
        public final ModConfigSpec.IntValue bootPosY;
        public final ModConfigSpec.IntValue mainPosX;
        public final ModConfigSpec.IntValue mainPosY;
        public final ModConfigSpec.IntValue offPosX;
        public final ModConfigSpec.IntValue offPosY;
        public final ModConfigSpec.IntValue arrPosX;
        public final ModConfigSpec.IntValue arrPosY;
        public final ModConfigSpec.IntValue invPosX;
        public final ModConfigSpec.IntValue invPosY;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> helmVal;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> helmHal;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> chestVal;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> chestHal;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> legVal;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> legHal;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> bootVal;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> bootHal;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> mainVal;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> mainHal;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> offVal;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> offHal;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> arrVal;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> arrHal;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> invVal;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> invHal;
        public final ModConfigSpec.BooleanValue showArmor;
        public final ModConfigSpec.BooleanValue showMain;
        public final ModConfigSpec.BooleanValue showOff;
        public final ModConfigSpec.BooleanValue showArrows;
        public final ModConfigSpec.BooleanValue showInv;
        public final ModConfigSpec.BooleanValue showEmpty;
        public final ModConfigSpec.BooleanValue moveAll;
        public final ModConfigSpec.BooleanValue showCount;
        public final ModConfigSpec.BooleanValue armBars;
        public final ModConfigSpec.BooleanValue armWithDebug;
        public final ModConfigSpec.BooleanValue showArrowsWithoutWeapon;
        public final ModConfigSpec.IntValue xArmPos;
        public final ModConfigSpec.IntValue yArmPos;
        public final ModConfigSpec.IntValue armAbove;
        public final ModConfigSpec.IntValue armScale;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> armValign;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> armHalign;
        public final ModConfigSpec.EnumValue<ArmorView> armView;
        public final ModConfigSpec.BooleanValue potionLevels;
        public final ModConfigSpec.BooleanValue potMini;
        public final ModConfigSpec.BooleanValue potHor;
        public final ModConfigSpec.BooleanValue showHiddenEffects;
        public final ModConfigSpec.BooleanValue potWithDebug;
        public final ModConfigSpec.IntValue xPotionPos;
        public final ModConfigSpec.IntValue yPotionPos;
        public final ModConfigSpec.IntValue potAlpha;
        public final ModConfigSpec.IntValue potGap;
        public final ModConfigSpec.IntValue barDuration;
        public final ModConfigSpec.EnumValue<WidgetAligns.VAlign> potValign;
        public final ModConfigSpec.EnumValue<WidgetAligns.HAlign> potHalign;
        public final ModConfigSpec.ConfigValue<List<String>> effectsBlacklist;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Settings for Inventory HUD").push("inventoryhud");
            this.invMini = builder.comment("Inventory HUD mini mode").define("invMini", false);
            this.invVert = builder.comment("Inventory HUD vertical mode").define("invVert", false);
            this.invAlpha = builder.comment("Inventory HUD alpha").defineInRange("invAlpha", 0, 0, 100);
            this.byDefault = builder.comment("Toggle on by default").define("byDefault", true);
            this.animatedInv = builder.comment("Animate recently picked up items").define("animatedInv", false);
            this.hideBackground = builder.comment("Hide background if inventory is empty").define("hideBackground", false);
            this.invWithDebug = builder.comment("Show Inventory HUD when debug menu is open").define("invWithDebug", true);
            builder.pop();
            builder.comment("Settings for ArmorStatus HUD").push("armorhud");
            this.ArmorDamage = builder.comment("Is Armor Damage HUD enabled").define("ArmorDamage", true);
            this.armAbove = builder.comment("Hide if durability is above this (in percentage):").defineInRange("armAbove", 100, 0, 100);
            this.showArmor = builder.comment("Show/Hide armor").define("showArmor", true);
            this.showMain = builder.comment("Show/Hide armor").define("showMain", true);
            this.showOff = builder.comment("Show/Hide armor").define("showOff", true);
            this.showArrows = builder.comment("Show/Hide armor").define("showArrows", true);
            this.showInv = builder.comment("Show/Hide armor").define("showInv", true);
            this.armView = builder.comment("Armor HUD durability view (PERCENTAGE, DAMAGE, DAMAGE LEFT)").defineEnum("armView", (Enum)ArmorView.PERCENTAGE);
            this.armBars = builder.comment("Show item durability bar").define("armBars", false);
            this.moveAll = builder.comment("Move all items at once or each one").define("moveAll", true);
            this.showEmpty = builder.comment("Show/Hide empty slot icon").define("showEmpty", true);
            this.showCount = builder.comment("Show overall count of items in main/off hand").define("showCount", false);
            this.armScale = builder.comment("ArmorHUD scale in persentage from 50 to 150").defineInRange("armScale", 100, 50, 150);
            this.armWithDebug = builder.comment("Show Armor HUD when debug menu is open").define("armWithDebug", true);
            this.showArrowsWithoutWeapon = builder.comment("Show arrows count when no weapon in your hands").define("showArrowsWithoutWeapon", true);
            builder.pop();
            builder.comment("Settings for Potions HUD").push("potionshud");
            this.Potions = builder.comment("Is Potions HUD enabled").define("Potions", true);
            this.potAlpha = builder.comment("Potion HUD alpha").defineInRange("potAlpha", 100, 0, 100);
            this.potGap = builder.comment("Potion HUD gap").defineInRange("potGap", 0, -5, 5);
            this.potMini = builder.comment("Potion HUD mini mode").define("potMini", false);
            this.potHor = builder.comment("Potion HUD horizontal mode").define("potHor", false);
            this.barDuration = builder.comment("Full bar duration").defineInRange("barDuration", 300, 1, Integer.MAX_VALUE);
            this.showHiddenEffects = builder.comment("Show hidden effects").define("showHiddenEffects", true);
            this.effectsBlacklist = builder.comment("Disable icons for effects in this list").define("effectsBlackList", new ArrayList());
            this.potWithDebug = builder.comment("Show Potion HUD when debug menu is open").define("potWithDebug", true);
            this.potionLevels = builder.comment("Show all levels of effects").define("potionLevels", false);
            builder.pop();
            builder.comment("DONT TOUCH THESE FIELDS!").push("positions");
            this.invValign = builder.comment("Inventory HUD vertical align").defineEnum("invValign", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.invHalign = builder.comment("Inventory HUD horizontal align").defineEnum("invHalign", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.xPos = builder.comment("Inventory HUD position (X)").defineInRange("xPos", 0, -9999, 9999);
            this.yPos = builder.comment("Inventory HUD position (Y)").defineInRange("yPos", 150, -9999, 9999);
            this.armValign = builder.comment("Armor HUD vertical align").defineEnum("armValign", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.armHalign = builder.comment("Armor HUD horizontal align").defineEnum("armHalign", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.xArmPos = builder.comment("Armor HUD position (X)").defineInRange("xArmPos", 0, -9999, 9999);
            this.yArmPos = builder.comment("Armor HUD position (Y)").defineInRange("yArmPos", 70, -9999, 9999);
            this.potValign = builder.comment("Potion HUD vertical align").defineEnum("potValign", (Enum)WidgetAligns.VAlign.TOP);
            this.potHalign = builder.comment("Potion HUD horizontal align").defineEnum("potHalign", (Enum)WidgetAligns.HAlign.LEFT);
            this.xPotionPos = builder.comment("Potion HUD position (X)").defineInRange("xPotionPos", 20, -9999, 9999);
            this.yPotionPos = builder.comment("Potion HUD position (Y)").defineInRange("yPotionPos", 20, -9999, 9999);
            this.helmPosX = builder.comment("Helmet position (X)").defineInRange("helmPosX", 103, -9999, 9999);
            this.helmPosY = builder.comment("Helmet position (Y)").defineInRange("helmPosY", 54, -9999, 9999);
            this.chestPosX = builder.comment("Chestplate position (X)").defineInRange("chestPosX", 103, -9999, 9999);
            this.chestPosY = builder.comment("Chestplate position (Y)").defineInRange("chestPosY", 37, -9999, 9999);
            this.legPosX = builder.comment("Leggings position (X)").defineInRange("legPosX", -103, -9999, 9999);
            this.legPosY = builder.comment("Leggings position (Y)").defineInRange("legPosY", 54, -9999, 9999);
            this.bootPosX = builder.comment("Boots position (X)").defineInRange("bootPosX", -103, -9999, 9999);
            this.bootPosY = builder.comment("Boots position (Y)").defineInRange("bootPosY", 37, -9999, 9999);
            this.mainPosX = builder.comment("MainHand position (X)").defineInRange("mainPosX", 103, -9999, 9999);
            this.mainPosY = builder.comment("MainHand position (Y)").defineInRange("mainPosY", 71, -9999, 9999);
            this.offPosX = builder.comment("OffHand position (X)").defineInRange("offPosX", -103, -9999, 9999);
            this.offPosY = builder.comment("OffHand position (Y)").defineInRange("offPosY", 71, -9999, 9999);
            this.arrPosX = builder.comment("Arrows position (X)").defineInRange("arrPosX", 103, -9999, 9999);
            this.arrPosY = builder.comment("Arrows position (Y)").defineInRange("arrPosY", 20, -9999, 9999);
            this.invPosX = builder.comment("InvIcon position (X)").defineInRange("invPosX", -103, -9999, 9999);
            this.invPosY = builder.comment("InvIcon position (Y)").defineInRange("invPosY", 20, -9999, 9999);
            this.helmHal = builder.comment("Helmet horizontal align").defineEnum("helmHal", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.helmVal = builder.comment("Helmet vertical align").defineEnum("helmVal", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.chestHal = builder.comment("Chestplate horizontal align").defineEnum("chestHal", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.chestVal = builder.comment("Chestplate vertical align").defineEnum("chestVal", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.legHal = builder.comment("Leggings horizontal align").defineEnum("legHal", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.legVal = builder.comment("Leggings vertical align").defineEnum("legVal", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.bootHal = builder.comment("Boots horizontal align").defineEnum("bootHal", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.bootVal = builder.comment("Boots vertical align").defineEnum("bootVal", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.mainHal = builder.comment("MainHand horizontal align").defineEnum("mainHal", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.mainVal = builder.comment("MainHand vertical align").defineEnum("mainVal", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.offHal = builder.comment("OffHand horizontal align").defineEnum("offHal", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.offVal = builder.comment("OffHand vertical align").defineEnum("offVal", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.arrHal = builder.comment("Arrows horizontal align").defineEnum("arrHal", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.arrVal = builder.comment("Arrows vertical align").defineEnum("arrVal", (Enum)WidgetAligns.VAlign.BOTTOM);
            this.invHal = builder.comment("InvIcon horizontal align").defineEnum("invHal", (Enum)WidgetAligns.HAlign.MIDDLE);
            this.invVal = builder.comment("InvIcon vertical align").defineEnum("invVal", (Enum)WidgetAligns.VAlign.BOTTOM);
            builder.pop();
            builder.comment("Notification settings").push("notification");
            this.lastNotifiedVersion = builder.comment("Last notified mod version").define("lastNotifiedVersion", (Object)InventoryHUD.version);
            this.keepNotifying = builder.comment("Notify more than once").define("keepNotifying", true);
            builder.pop();
        }
    }

    public static enum ArmorView {
        PERCENTAGE,
        DAMAGE,
        DAMAGE_LEFT,
        OFF;

    }
}

