/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.config.NoiseSphereConfig;

public class NoiseSphere
extends Feature<NoiseSphereConfig> {
    public NoiseSphere(Codec<NoiseSphereConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoiseSphereConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        NoiseSphereConfig config = (NoiseSphereConfig)context.config();
        RandomSource random = context.random();
        int radius = config.radius().sample(random);
        float freq = config.noiseFrequency().sample(random);
        ImprovedNoise noise = new ImprovedNoise(random);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        LongOpenHashSet cache = new LongOpenHashSet();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double noiseDelta;
                    double localRadius;
                    mutableBlockPos.setWithOffset((Vec3i)origin, x, y, z);
                    if (!origin.closerThan((Vec3i)mutableBlockPos, (double)radius) || !origin.closerThan((Vec3i)mutableBlockPos, localRadius = Mth.clampedLerp((double)((double)radius * 0.5), (double)radius, (double)(noiseDelta = (noise.noise((double)((float)mutableBlockPos.getX() * freq), (double)((float)mutableBlockPos.getY() * freq), (double)((float)mutableBlockPos.getZ() * freq)) + 1.0) * 0.5)))) continue;
                    cache.add(mutableBlockPos.asLong());
                }
            }
        }
        for (Pair<BlockPredicate, BlockStateProvider> blockPlacement : config.checkedBlockPlacement().blockPlacement()) {
            cache.forEach(pos -> {
                mutableBlockPos.set(pos);
                if (((BlockPredicate)blockPlacement.getFirst()).test((Object)level, (Object)mutableBlockPos)) {
                    level.setBlock((BlockPos)mutableBlockPos, ((BlockStateProvider)blockPlacement.getSecond()).getState(random, (BlockPos)mutableBlockPos), 2);
                }
            });
        }
        return true;
    }
}

