/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.flower;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.potionstudios.biomeswevegone.world.level.block.plants.flower.BWGFlowerBlock;
import org.jetbrains.annotations.NotNull;

public class BWGBonemealableFlowerBlock
extends BWGFlowerBlock
implements BonemealableBlock {
    private final Supplier<? extends Block> growableBlock;

    public BWGBonemealableFlowerBlock(BlockBehaviour.Properties properties, TagKey<Block> validGround, VoxelShape shape, Supplier<? extends Block> growableBlock) {
        super(properties, validGround, shape);
        this.growableBlock = growableBlock;
    }

    public BWGBonemealableFlowerBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> growableBlock) {
        super(properties);
        this.growableBlock = growableBlock;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockState growableState = this.growableBlock.get().defaultBlockState();
        if (growableState.canSurvive((LevelReader)level, pos)) {
            if (this.growableBlock.get() instanceof DoublePlantBlock) {
                DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)growableState, (BlockPos)pos, (int)2);
            } else {
                level.setBlock(pos, growableState, 3);
            }
        }
    }
}

