/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.custom.PumpkinBurrowBlock;

public class SetWalkTargetFromBlockMemory {
    public static OneShot<PumpkinWarden> create(MemoryModuleType<GlobalPos> blockTargetMemory, float speedModifier, int closeEnoughDist, int tooFarDistance, int tooLongUnreachableDuration) {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE), (App)instance.absent(MemoryModuleType.WALK_TARGET), (App)instance.present(blockTargetMemory)).apply((Applicative)instance, (memoryAccessor, memoryAccessor2, memoryAccessor3) -> (serverLevel, pumpkinWarden, l) -> {
            GlobalPos globalPos = (GlobalPos)instance.get(memoryAccessor3);
            Optional optional = instance.tryGet(memoryAccessor);
            if (globalPos.dimension() == serverLevel.dimension() && (optional.isEmpty() || serverLevel.getGameTime() - (Long)optional.get() <= (long)tooLongUnreachableDuration)) {
                BlockPos targetPos = globalPos.pos();
                if (blockTargetMemory == MemoryModuleType.HOME && serverLevel.getBlockState(targetPos).is((Block)BWGBlocks.PUMPKIN_BURROW.get())) {
                    Direction facing = (Direction)serverLevel.getBlockState(targetPos).getValue((Property)PumpkinBurrowBlock.FACING);
                    targetPos = targetPos.relative(facing);
                }
                if (targetPos.distManhattan((Vec3i)pumpkinWarden.blockPosition()) > tooFarDistance) {
                    Vec3 vec3 = null;
                    int m = 0;
                    while (vec3 == null || BlockPos.containing(vec3).distManhattan((Vec3i)pumpkinWarden.blockPosition()) > tooFarDistance) {
                        vec3 = DefaultRandomPos.getPosTowards((PathfinderMob)pumpkinWarden, (int)15, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)targetPos), (double)1.5707963705062866);
                        if (++m != 1000) continue;
                        pumpkinWarden.releasePoi(blockTargetMemory);
                        memoryAccessor3.erase();
                        memoryAccessor.set((Object)l);
                        return true;
                    }
                    memoryAccessor2.set((Object)new WalkTarget(vec3, speedModifier, closeEnoughDist));
                } else if (targetPos.distManhattan((Vec3i)pumpkinWarden.blockPosition()) > closeEnoughDist) {
                    memoryAccessor2.set((Object)new WalkTarget(targetPos, speedModifier, closeEnoughDist));
                }
            } else {
                pumpkinWarden.releasePoi(blockTargetMemory);
                memoryAccessor3.erase();
                memoryAccessor.set((Object)l);
            }
            return true;
        }));
    }
}

